"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAndGetSyntaxErrors = void 0;
var _antlr4ts = require("antlr4ts");
var _painless_parser = require("../../antlr/painless_parser");
var _lexer = require("./lexer");
var _error_listener = require("../../../common/error_listener");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const parse = code => {
  const inputStream = _antlr4ts.CharStreams.fromString(code);
  const lexer = new _lexer.PainlessLexerEnhanced(inputStream);
  const painlessLangErrorListener = new _error_listener.ANTLREErrorListener();
  const tokenStream = new _antlr4ts.CommonTokenStream(lexer);
  const parser = new _painless_parser.painless_parser(tokenStream);
  lexer.removeErrorListeners();
  parser.removeErrorListeners();
  lexer.addErrorListener(painlessLangErrorListener);
  parser.addErrorListener(painlessLangErrorListener);
  const errors = painlessLangErrorListener.getErrors();
  return {
    source: parser.source(),
    errors
  };
};
const parseAndGetSyntaxErrors = code => {
  const {
    errors
  } = parse(code);
  return errors;
};
exports.parseAndGetSyntaxErrors = parseAndGetSyntaxErrors;