"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLTokensProvider = void 0;
var _antlr4ts = require("antlr4ts");
var _error_listener = require("../../../common/error_listener");
var _esql_token = require("./esql_token");
var _esql_line_tokens = require("./esql_line_tokens");
var _esql_state = require("./esql_state");
var _antlr_facade = require("../antlr_facade");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EOF = -1;
class ESQLTokensProvider {
  getInitialState() {
    return new _esql_state.ESQLState();
  }
  tokenize(line, state) {
    const errorStartingPoints = [];
    const errorListener = new _error_listener.ANTLREErrorListener();
    const inputStream = _antlr4ts.CharStreams.fromString(line);
    const lexer = (0, _antlr_facade.getLexer)(inputStream, errorListener);
    let done = false;
    const myTokens = [];
    do {
      let token;
      try {
        token = lexer.nextToken();
      } catch (e) {
        token = null;
      }
      if (token == null) {
        done = true;
      } else {
        if (token.type === EOF) {
          done = true;
        } else {
          const tokenTypeName = lexer.vocabulary.getSymbolicName(token.type);
          if (tokenTypeName) {
            const myToken = new _esql_token.ESQLToken(tokenTypeName, token.startIndex, token.stopIndex);
            myTokens.push(myToken);
          }
        }
      }
    } while (!done);
    for (const e of errorStartingPoints) {
      myTokens.push(new _esql_token.ESQLToken('error' + _constants.ESQL_TOKEN_POSTFIX, e));
    }
    myTokens.sort((a, b) => a.startIndex - b.startIndex);
    return new _esql_line_tokens.ESQLLineTokens(myTokens);
  }
}
exports.ESQLTokensProvider = ESQLTokensProvider;