"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLLang = void 0;
var _monaco_imports = require("../monaco_imports");
var _constants = require("./lib/constants");
var _diagnostics_adapter = require("../common/diagnostics_adapter");
var _worker_proxy = require("../common/worker_proxy");
var _esql_completion_provider = require("./lib/monaco/esql_completion_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const workerProxyService = new _worker_proxy.WorkerProxyService();
const ESQLLang = {
  ID: _constants.ESQL_LANG_ID,
  async onLanguage() {
    const {
      ESQLTokensProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./lib/monaco')));
    workerProxyService.setup(_constants.ESQL_LANG_ID);
    _monaco_imports.monaco.languages.setTokensProvider(_constants.ESQL_LANG_ID, new ESQLTokensProvider());
    new _diagnostics_adapter.DiagnosticsAdapter(_constants.ESQL_LANG_ID, (...uris) => workerProxyService.getWorker(uris));
  },
  languageConfiguration: {
    brackets: [['(', ')']],
    autoClosingPairs: [{
      open: '(',
      close: ')'
    }, {
      open: `'`,
      close: `'`
    }, {
      open: '"',
      close: '"'
    }],
    surroundingPairs: [{
      open: '(',
      close: ')'
    }, {
      open: `'`,
      close: `'`
    }, {
      open: '"',
      close: '"'
    }]
  },
  getSuggestionProvider(callbacks) {
    return new _esql_completion_provider.ESQLCompletionAdapter((...uris) => workerProxyService.getWorker(uris), callbacks);
  }
};
exports.ESQLLang = ESQLLang;