"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/core/public");
var _get_shared_ml_services = require("./application/services/get_shared_ml_services");
var _management = require("./application/management");
var _locator = require("./locator");
var _dependency_cache = require("./application/util/dependency_cache");
var _register_home_feature = require("./register_home_feature");
var _license = require("../common/license");
var _app = require("../common/constants/app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class MlPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "sharedMlServices", void 0);
    (0, _defineProperty2.default)(this, "isServerless", false);
    (0, _defineProperty2.default)(this, "enabledFeatures", {
      ad: true,
      dfa: true,
      nlp: true
    });
    this.initializerContext = initializerContext;
    this.isServerless = initializerContext.env.packageInfo.buildFlavor === 'serverless';
    (0, _app.initEnabledFeatures)(this.enabledFeatures, initializerContext.config.get());
  }
  setup(core, pluginsSetup) {
    this.sharedMlServices = (0, _get_shared_ml_services.getMlSharedServices)(core.http);
    core.application.register({
      id: _app.PLUGIN_ID,
      title: _i18n.i18n.translate('xpack.ml.plugin.title', {
        defaultMessage: 'Machine Learning'
      }),
      order: 5000,
      euiIconType: _app.PLUGIN_ICON_SOLUTION,
      appRoute: _app.ML_APP_ROUTE,
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      updater$: this.appUpdater$,
      mount: async params => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/app')));
        return renderApp(coreStart, {
          cases: pluginsStart.cases,
          charts: pluginsStart.charts,
          contentManagement: pluginsStart.contentManagement,
          dashboard: pluginsStart.dashboard,
          data: pluginsStart.data,
          dataViewEditor: pluginsStart.dataViewEditor,
          dataVisualizer: pluginsStart.dataVisualizer,
          embeddable: {
            ...pluginsSetup.embeddable,
            ...pluginsStart.embeddable
          },
          fieldFormats: pluginsStart.fieldFormats,
          home: pluginsSetup.home,
          kibanaVersion: this.initializerContext.env.packageInfo.version,
          lens: pluginsStart.lens,
          licenseManagement: pluginsSetup.licenseManagement,
          licensing: pluginsStart.licensing,
          management: pluginsSetup.management,
          maps: pluginsStart.maps,
          presentationUtil: pluginsStart.presentationUtil,
          savedObjectsManagement: pluginsStart.savedObjectsManagement,
          savedSearch: pluginsStart.savedSearch,
          security: pluginsStart.security,
          share: pluginsStart.share,
          triggersActionsUi: pluginsStart.triggersActionsUi,
          uiActions: pluginsStart.uiActions,
          unifiedSearch: pluginsStart.unifiedSearch,
          usageCollection: pluginsSetup.usageCollection
        }, params, this.isServerless, this.enabledFeatures);
      }
    });
    if (pluginsSetup.share) {
      this.locator = pluginsSetup.share.url.locators.create(new _locator.MlLocatorDefinition());
    }
    if (pluginsSetup.management) {
      (0, _management.registerManagementSection)(pluginsSetup.management, core, {
        usageCollection: pluginsSetup.usageCollection
      }, this.isServerless, this.enabledFeatures).enable();
    }
    const licensing = pluginsSetup.licensing.license$.pipe((0, _operators.take)(1));
    licensing.pipe((0, _rxjs.mergeMap)(async license => {
      const mlEnabled = (0, _license.isMlEnabled)(license);
      const fullLicense = (0, _license.isFullLicense)(license);
      const [coreStart, pluginStart] = await core.getStartServices();
      const {
        capabilities
      } = coreStart.application;
      const mlCapabilities = capabilities.ml;

      // register various ML plugin features which require a full license
      // note including registerHomeFeature in register_helper would cause the page bundle size to increase significantly
      if (mlEnabled) {
        // add ML to home page
        if (pluginsSetup.home) {
          (0, _register_home_feature.registerHomeFeature)(pluginsSetup.home);
        }
        const {
          registerEmbeddables,
          registerMlUiActions,
          registerSearchLinks,
          registerMlAlerts,
          registerMapExtension,
          registerCasesAttachments
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./register_helper')));
        registerSearchLinks(this.appUpdater$, fullLicense, mlCapabilities, !this.isServerless);
        if (pluginsSetup.triggersActionsUi && (fullLicense && mlCapabilities.canUseMlAlerts && mlCapabilities.canGetJobs ||
        // Register rules for basic license to show them in the UI as disabled
        !fullLicense)) {
          registerMlAlerts(pluginsSetup.triggersActionsUi, core.getStartServices, pluginsSetup.alerting);
        }
        if (fullLicense) {
          registerMlUiActions(pluginsSetup.uiActions, core);
          if (this.enabledFeatures.ad) {
            registerEmbeddables(pluginsSetup.embeddable, core);
            if (pluginsSetup.cases) {
              registerCasesAttachments(pluginsSetup.cases, coreStart, pluginStart);
            }
            if (pluginsSetup.maps) {
              // Pass canGetJobs as minimum permission to show anomalies card in maps layers
              await registerMapExtension(pluginsSetup.maps, core, {
                canGetJobs: mlCapabilities.canGetJobs,
                canCreateJobs: mlCapabilities.canCreateJob
              });
            }
          }
        }
      } else {
        // if ml is disabled in elasticsearch, disable ML in kibana
        this.appUpdater$.next(() => ({
          status: _public.AppStatus.inaccessible
        }));
      }
    })).subscribe();
    return {
      locator: this.locator,
      elasticModels: this.sharedMlServices.elasticModels
    };
  }
  start(core, deps) {
    var _this$sharedMlService, _this$sharedMlService2;
    (0, _dependency_cache.setDependencyCache)({
      docLinks: core.docLinks,
      basePath: core.http.basePath,
      http: core.http,
      i18n: core.i18n,
      lens: deps.lens
    });
    return {
      locator: this.locator,
      elasticModels: (_this$sharedMlService = this.sharedMlServices) === null || _this$sharedMlService === void 0 ? void 0 : _this$sharedMlService.elasticModels,
      mlApi: (_this$sharedMlService2 = this.sharedMlServices) === null || _this$sharedMlService2 === void 0 ? void 0 : _this$sharedMlService2.mlApiServices
    };
  }
  stop() {}
}
exports.MlPlugin = MlPlugin;