"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeriesChartWithTooltips = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _chart_tooltip = require("../../../components/chart_tooltip");
var _timeseries_chart = require("./timeseries_chart");
var _search = require("../../../../../common/constants/search");
var _kibana = require("../../../contexts/kibana");
var _time_buckets = require("../../../util/time_buckets");
var _get_controls_for_detector = require("../../get_controls_for_detector");
var _ml_annotation_updates_context = require("../../../contexts/ml/ml_annotation_updates_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeSeriesChartWithTooltips = ({
  bounds,
  detectorIndex,
  renderFocusChartOnly,
  selectedJob,
  selectedEntities,
  showAnnotations,
  showForecast,
  showModelBounds,
  chartProps,
  lastRefresh,
  contextAggregationInterval
}) => {
  const {
    toasts: toastNotifications
  } = (0, _kibana.useNotifications)();
  const {
    services: {
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const annotationUpdatesService = (0, _react.useContext)(_ml_annotation_updates_context.MlAnnotationUpdatesContext);
  const [annotationData, setAnnotationData] = (0, _react.useState)([]);
  const showAnnotationErrorToastNotification = (0, _react.useCallback)(error => {
    toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.mlSingleMetricViewerChart.annotationsErrorTitle', {
        defaultMessage: 'An error occurred fetching annotations'
      }),
      ...(error ? {
        text: (0, _mlErrorUtils.extractErrorMessage)(error)
      } : {})
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    let unmounted = false;
    const entities = (0, _get_controls_for_detector.getControlsForDetector)(detectorIndex, selectedEntities, selectedJob.job_id);
    const nonBlankEntities = Array.isArray(entities) ? entities.filter(entity => entity.fieldValue !== null) : undefined;
    const searchBounds = (0, _time_buckets.getBoundsRoundedToInterval)(bounds, contextAggregationInterval, false);

    /**
     * Loads the full list of annotations for job without any aggs or time boundaries
     * used to indicate existence of annotations that are beyond the selected time
     * in the time series brush area
     */
    const loadAnnotations = async jobId => {
      try {
        const resp = await mlApiServices.annotations.getAnnotations({
          jobIds: [jobId],
          earliestMs: searchBounds.min.valueOf(),
          latestMs: searchBounds.max.valueOf(),
          maxAnnotations: _search.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE,
          detectorIndex,
          entities: nonBlankEntities
        });
        if (!unmounted) {
          if (Array.isArray(resp.annotations[jobId])) {
            setAnnotationData(resp.annotations[jobId]);
          }
        }
      } catch (error) {
        showAnnotationErrorToastNotification(error);
      }
    };
    loadAnnotations(selectedJob.job_id);
    return () => {
      unmounted = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedJob.job_id, detectorIndex, lastRefresh, selectedEntities, bounds, contextAggregationInterval]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-timeseries-chart",
    "data-test-subj": "mlSingleMetricViewerChart"
  }, /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, null, tooltipService => /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, (0, _extends2.default)({}, chartProps, {
    annotationUpdatesService: annotationUpdatesService,
    annotationData: annotationData,
    bounds: bounds,
    detectorIndex: detectorIndex,
    renderFocusChartOnly: renderFocusChartOnly,
    selectedJob: selectedJob,
    showAnnotations: showAnnotations,
    showForecast: showForecast,
    showModelBounds: showModelBounds,
    tooltipService: tooltipService
  }))));
};
exports.TimeSeriesChartWithTooltips = TimeSeriesChartWithTooltips;