"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newJobCapsServiceAnalytics = void 0;
exports.removeNestedFieldChildren = removeNestedFieldChildren;
var _fieldTypes = require("@kbn/field-types");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _new_job_capabilities = require("./new_job_capabilities");
var _ml_api_service = require("../ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Keep top nested field and remove all <nested_field>.* fields
function removeNestedFieldChildren(resp, indexPatternTitle) {
  const results = resp[indexPatternTitle];
  const fields = [];
  const nestedFields = {};
  if (results !== undefined) {
    results.fields.forEach(field => {
      if (field.type === _fieldTypes.ES_FIELD_TYPES.NESTED && nestedFields[field.name] === undefined) {
        nestedFields[field.name] = true;
        fields.push(field);
      }
    });
    if (Object.keys(nestedFields).length > 0) {
      results.fields.forEach(field => {
        if (field.type !== _fieldTypes.ES_FIELD_TYPES.NESTED) {
          const fieldNameParts = field.name.split('.');
          const rootOfField = fieldNameParts.shift();
          if (rootOfField && nestedFields[rootOfField] === undefined) {
            fields.push(field);
          }
        }
      });
    } else {
      fields.push(...results.fields);
    }
  }
  return fields;
}
class NewJobCapsServiceAnalytics extends _new_job_capabilities.NewJobCapabilitiesServiceBase {
  async initializeFromDataVIew(dataView) {
    try {
      const resp = await _ml_api_service.ml.dataFrameAnalytics.newJobCapsAnalytics(dataView.getIndexPattern(), dataView.type === 'rollup');
      const allFields = removeNestedFieldChildren(resp, dataView.getIndexPattern());
      const {
        fieldsPreferringKeyword
      } = (0, _new_job_capabilities.processTextAndKeywordFields)(allFields);

      // set the main fields list to contain fields which have been filtered to prefer
      // keyword fields over text fields.
      // e.g. if foo.keyword and foo exist, don't add foo to the list.
      this._fields = fieldsPreferringKeyword;
      this.removeCounterFields();
    } catch (error) {
      console.error('Unable to load analytics index fields', error); // eslint-disable-line no-console
    }
  }

  isKeywordAndTextType(fieldName) {
    var _this$fields$find;
    const fieldType = (_this$fields$find = this.fields.find(field => field.name === fieldName)) === null || _this$fields$find === void 0 ? void 0 : _this$fields$find.type;
    let isBothTypes = false;

    // If it's a keyword type - check if it has a corresponding text type
    if (fieldType !== undefined && fieldType === _fieldTypes.ES_FIELD_TYPES.KEYWORD) {
      const field = this.getFieldById(fieldName.replace(/\.keyword$/, ''));
      isBothTypes = field !== null && field.type === _fieldTypes.ES_FIELD_TYPES.TEXT;
    } else if (fieldType !== undefined && fieldType === _fieldTypes.ES_FIELD_TYPES.TEXT) {
      //   If text, check if has corresponding keyword type
      const field = this.getFieldById(`${fieldName}.keyword`);
      isBothTypes = field !== null && field.type === _fieldTypes.ES_FIELD_TYPES.KEYWORD;
    }
    return isBothTypes;
  }
  getDefaultFields(jobConfig, needsDestIndexFields) {
    let fields = [...this.fields];
    const fieldsObj = {
      selectedFields: [],
      docFields: []
    };
    if (fields.length === 0) {
      return fieldsObj;
    }

    // default is 'ml'
    const resultsField = jobConfig.dest.results_field;
    const allFields = [];
    let type;
    let predictedField;
    if ((0, _mlDataFrameAnalyticsUtils.isOutlierAnalysis)(jobConfig.analysis)) {
      if (!jobConfig.analysis.outlier_detection.compute_feature_influence) {
        // remove all feature influence fields
        fields = fields.filter(field => !field.name.includes(`${resultsField}.${_mlDataFrameAnalyticsUtils.FEATURE_INFLUENCE}`));
      } else {
        // remove flattened feature influence fields
        fields = fields.filter(field => !field.name.includes(`${resultsField}.${_mlDataFrameAnalyticsUtils.FEATURE_INFLUENCE}.`));
      }

      // Only need to add these fields if we didn't use dest data view to get the fields
      if (needsDestIndexFields === true) {
        allFields.push({
          id: `${resultsField}.${_mlDataFrameAnalyticsUtils.OUTLIER_SCORE}`,
          name: `${resultsField}.${_mlDataFrameAnalyticsUtils.OUTLIER_SCORE}`,
          type: _fieldTypes.KBN_FIELD_TYPES.NUMBER
        });
      }
    }
    if ((0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(jobConfig.analysis) || (0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(jobConfig.analysis)) {
      var _this$getFieldById;
      const dependentVariable = (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis);
      type = (_this$getFieldById = this.getFieldById(dependentVariable)) === null || _this$getFieldById === void 0 ? void 0 : _this$getFieldById.type;
      const predictionFieldName = (0, _mlDataFrameAnalyticsUtils.getPredictionFieldName)(jobConfig.analysis);
      const numTopFeatureImportanceValues = (0, _mlDataFrameAnalyticsUtils.getNumTopFeatureImportanceValues)(jobConfig.analysis);
      const numTopClasses = (0, _mlDataFrameAnalyticsUtils.getNumTopClasses)(jobConfig.analysis);
      const defaultPredictionField = `${dependentVariable}_prediction`;
      predictedField = `${resultsField}.${predictionFieldName ? predictionFieldName : defaultPredictionField}`;
      if ((numTopFeatureImportanceValues !== null && numTopFeatureImportanceValues !== void 0 ? numTopFeatureImportanceValues : 0) === 0) {
        // remove all feature importance fields
        fields = this.fields.filter(field => !field.name.includes(`${resultsField}.${_mlDataFrameAnalyticsUtils.FEATURE_IMPORTANCE}`));
      } else {
        // remove flattened feature importance fields
        fields = fields.filter(field => !field.name.includes(`${resultsField}.${_mlDataFrameAnalyticsUtils.FEATURE_IMPORTANCE}.`));
      }
      if ((numTopClasses !== null && numTopClasses !== void 0 ? numTopClasses : 0) === 0) {
        // remove all top classes fields
        fields = fields.filter(field => !field.name.includes(`${resultsField}.${_mlDataFrameAnalyticsUtils.TOP_CLASSES}`));
      } else {
        // remove flattened top classes fields
        fields = fields.filter(field => !field.name.includes(`${resultsField}.${_mlDataFrameAnalyticsUtils.TOP_CLASSES}.`));
      }

      // Only need to add these fields if we didn't use dest data view to get the fields
      if (needsDestIndexFields === true) {
        allFields.push({
          id: `${resultsField}.is_training`,
          name: `${resultsField}.is_training`,
          type: _fieldTypes.ES_FIELD_TYPES.BOOLEAN
        }, {
          id: predictedField,
          name: predictedField,
          type
        });
      }
    }
    allFields.push(...fields);
    allFields.sort(({
      name: a
    }, {
      name: b
    }) => (0, _mlDataFrameAnalyticsUtils.sortExplorationResultsFields)(a, b, jobConfig));
    let selectedFields = allFields.filter(field => field.name === predictedField || !field.name.includes('.keyword'));
    if (selectedFields.length > _mlDataFrameAnalyticsUtils.DEFAULT_REGRESSION_COLUMNS) {
      selectedFields = selectedFields.slice(0, _mlDataFrameAnalyticsUtils.DEFAULT_REGRESSION_COLUMNS);
    }
    return {
      selectedFields,
      docFields: allFields,
      depVarType: type
    };
  }
}
const newJobCapsServiceAnalytics = new NewJobCapsServiceAnalytics();
exports.newJobCapsServiceAnalytics = newJobCapsServiceAnalytics;