"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldTypeFromMapping = getFieldTypeFromMapping;
var _lodash = require("lodash");
var _ml_api_service = require("./ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Returns the mapping type of the specified field.
// Accepts fieldName containing dots representing a nested sub-field.
function getFieldTypeFromMapping(index, fieldName) {
  return new Promise((resolve, reject) => {
    if (index !== '') {
      _ml_api_service.ml.getFieldCaps({
        index,
        fields: [fieldName]
      }).then(resp => {
        let fieldType = '';
        (0, _lodash.each)(resp.fields, field => {
          (0, _lodash.each)(field, type => {
            if (fieldType === '') {
              fieldType = type.type;
            }
          });
        });
        resolve(fieldType);
      }).catch(error => {
        reject(error);
      });
    } else {
      reject();
    }
  });
}