"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRouteResolver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _access_denied = require("../access_denied");
var _app = require("../../../common/constants/app");
var _kibana = require("../contexts/kibana");
var _check_capabilities = require("../capabilities/check_capabilities");
var _locator = require("../../../common/constants/locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolves required dependencies for landing on the page
 * and performs redirects if needed.
 *
 * @param requiredLicense
 * @param requiredCapabilities
 */
const useRouteResolver = (requiredLicense, requiredCapabilities, customResolvers) => {
  const requiredCapabilitiesRef = (0, _react.useRef)(requiredCapabilities);
  const customResolversRef = (0, _react.useRef)(customResolvers);
  const [results, setResults] = (0, _react.useState)();
  const [context, setContext] = (0, _react.useState)({
    initialized: false
  });
  const {
    services: {
      application: {
        navigateToApp,
        navigateToUrl
      },
      mlServices: {
        mlCapabilities
      },
      uiSettings,
      data: {
        dataViews
      },
      notifications,
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlLicenseInfo = (0, _kibana.useMlLicenseInfo)();
  (0, _useMount.default)(function refreshCapabilitiesOnMount() {
    mlCapabilities.refreshCapabilities();
  });
  const licenseResolver = (0, _react.useCallback)(async () => {
    if (mlLicenseInfo.isMlEnabled === false || mlLicenseInfo.isMinimumLicense === false) {
      // ML is not enabled or the license isn't at least basic
      await navigateToApp('home');
      return Promise.reject();
    }
    if (requiredLicense === 'full' && mlLicenseInfo.isFullLicense === false) {
      // ML is enabled, but only with a basic or gold license
      await navigateToApp(_app.PLUGIN_ID, {
        path: _locator.ML_PAGES.DATA_VISUALIZER
      });
      return Promise.reject();
    }
    if (mlLicenseInfo.hasLicenseExpired) {
      await navigateToUrl(await locators.get('LICENSE_MANAGEMENT_LOCATOR').getUrl({
        page: 'dashboard'
      }));
      return Promise.reject();
    }
    return true;
  }, [locators, mlLicenseInfo.hasLicenseExpired, mlLicenseInfo.isFullLicense, mlLicenseInfo.isMinimumLicense, mlLicenseInfo.isMlEnabled, navigateToApp, navigateToUrl, requiredLicense]);

  // Check if the user has all required permissions
  const capabilitiesResults = (0, _check_capabilities.usePermissionCheck)(requiredCapabilities);
  const capabilitiesResolver = (0, _react.useCallback)(async () => {
    const missingCapabilities = requiredCapabilitiesRef.current.filter((k, i) => !capabilitiesResults[i]);
    if (missingCapabilities.length > 0) {
      setContext({
        initialized: true,
        resolvedComponent: /*#__PURE__*/_react.default.createElement(_access_denied.AccessDeniedCallout, {
          missingCapabilities: missingCapabilities
        })
      });
      return Promise.reject();
    }
    return true;
  }, [capabilitiesResults]);
  const resolveCustomResolvers = (0, _react.useCallback)(async () => {
    if (!customResolversRef.current) return;
    const funcNames = Object.keys(customResolversRef.current); // Object.entries gets this wrong?!
    const funcs = Object.values(customResolversRef.current); // Object.entries gets this wrong?!
    const tempResults = funcNames.reduce((p, c) => {
      p[c] = {};
      return p;
    }, {});
    const res = await Promise.all(funcs.map(r => r()));
    res.forEach((r, i) => tempResults[funcNames[i]] = r);
    return tempResults;
  }, []);
  (0, _react.useEffect)(function resolveRequirements() {
    let mounted = true;

    // Sequence is important
    licenseResolver().then(capabilitiesResolver).then(resolveCustomResolvers).then(customResults => {
      if (mounted) {
        setContext({
          initialized: true
        });
        setResults(customResults);
      }
    }).catch(rejectedValue => {
      if (rejectedValue instanceof Error) {
        notifications.toasts.addError(rejectedValue, {
          title: _i18n.i18n.translate('xpack.ml.useResolver.errorTitle', {
            defaultMessage: 'An error has occurred'
          })
        });
      }
    });
    return () => {
      mounted = false;
    };
  }, [licenseResolver, mlLicenseInfo, capabilitiesResolver, notifications.toasts, resolveCustomResolvers, dataViews, uiSettings]);
  return {
    context,
    results
  };
};
exports.useRouteResolver = useRouteResolver;