"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changePointDetectionRouteFactory = void 0;
var _common = require("@kbn/aiops-plugin/common");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ml = require("../../../contexts/ml");
var _locator = require("../../../../locator");
var _breadcrumbs = require("../../breadcrumbs");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _aiops = require("../../../aiops");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const changePointDetectionRouteFactory = (navigateToPath, basePath) => ({
  id: 'change_point_detection',
  path: (0, _router.createPath)(_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION),
  title: _i18n.i18n.translate('xpack.ml.aiops.changePointDetection.docTitle', {
    defaultMessage: 'Change point detection'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbs.changePointDetectionLabel', {
      defaultMessage: 'Change point detection'
    })
  }],
  disabled: !_common.CHANGE_POINT_DETECTION_ENABLED
});
exports.changePointDetectionRouteFactory = changePointDetectionRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canUseAiops']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, /*#__PURE__*/_react.default.createElement(_aiops.ChangePointDetectionPage, null)));
};