"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextClassificationOutputComponent = exports.TextClassificationOutput = exports.PredictionProbabilityList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTextClassificationOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(TextClassificationOutput, {
  inferrer: inferrer
});
exports.getTextClassificationOutputComponent = getTextClassificationOutputComponent;
const TextClassificationOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(({
    response,
    inputText
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(PredictionProbabilityList, {
    response: response,
    inputText: inputText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))));
};
exports.TextClassificationOutput = TextClassificationOutput;
const PredictionProbabilityList = ({
  response,
  inputText
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inputText !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, inputText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, response.map(({
    value,
    predictionProbability
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: predictionProbability * 100,
    max: 100,
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `mlTestModelLangIdentInputValue`
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `mlTestModelLangIdentInputProbability`,
    grow: false
  }, predictionProbability)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
};
exports.PredictionProbabilityList = PredictionProbabilityList;