"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceInputFormIndexControls = void 0;
exports.useIndexInput = useIndexInput;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../contexts/kibana");
var _inference_base = require("./inference_base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceInputFormIndexControls = ({
  inferrer,
  data
}) => {
  const {
    dataViewListItems,
    fieldNames,
    selectedDataViewId,
    setSelectedDataViewId,
    selectedField,
    setSelectedField
  } = data;
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const pipeline = (0, _useObservable.default)(inferrer.getPipeline$(), inferrer.getPipeline());
  const inputComponent = (0, _react.useMemo)(() => inferrer.getInputComponent(), [inferrer]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Index",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: dataViewListItems,
    value: selectedDataViewId,
    onChange: e => setSelectedDataViewId(e.target.value),
    hasNoInitialSelection: true,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.indexInput.fieldInput', {
      defaultMessage: 'Field'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: fieldNames,
    value: selectedField,
    onChange: e => setSelectedField(e.target.value),
    hasNoInitialSelection: true,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inputComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'simpleAccordionId',
    buttonContent: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.indexInput.viewPipeline', {
      defaultMessage: 'View pipeline'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "s",
    paddingSize: "s",
    lineNumbers: true,
    isCopyable: true
  }, JSON.stringify(pipeline, null, 2))));
};
exports.InferenceInputFormIndexControls = InferenceInputFormIndexControls;
function useIndexInput({
  inferrer
}) {
  const {
    services: {
      data: {
        dataViews,
        search: {
          search
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [dataViewListItems, setDataViewListItems] = (0, _react.useState)([]);
  const [selectedDataViewId, setSelectedDataViewId] = (0, _react.useState)(undefined);
  const [selectedDataView, setSelectedDataView] = (0, _react.useState)(null);
  const [fieldNames, setFieldNames] = (0, _react.useState)([]);
  const selectedField = (0, _useObservable.default)(inferrer.getInputField$(), inferrer.getInputField());
  const setSelectedField = (0, _react.useCallback)(fieldName => inferrer.setInputField(fieldName), [inferrer]);
  (0, _react.useEffect)(function loadDataViewListItems() {
    async function getFilteredDataViewListItems() {
      const dataViewIds = await dataViews.getIdsWithTitle();
      const supportedFieldTypes = inferrer.getSupportedFieldTypes();
      const hasTextField = async ({
        id
      }) => {
        const dataView = await dataViews.get(id);
        return dataView.fields.getAll().some(dvField => supportedFieldTypes.some(esType => {
          var _dvField$esTypes;
          return (_dvField$esTypes = dvField.esTypes) === null || _dvField$esTypes === void 0 ? void 0 : _dvField$esTypes.includes(esType);
        }));
      };
      const allPromises = dataViewIds.map(hasTextField);
      const resolvedPromises = await Promise.all(allPromises);
      const filteredDataViews = dataViewIds.filter((value, index) => resolvedPromises[index]);
      setDataViewListItems(filteredDataViews.sort((a, b) => a.title.localeCompare(b.title)).map(({
        id,
        title
      }) => ({
        text: title,
        value: id
      })));
    }
    getFilteredDataViewListItems();
  }, [dataViews, inferrer]);
  (0, _react.useEffect)(function loadSelectedDataView() {
    inferrer.reset();
    setFieldNames([]);
    if (selectedDataViewId !== undefined) {
      dataViews.get(selectedDataViewId).then(dv => setSelectedDataView(dv));
    }
  }, [selectedDataViewId, dataViews, inferrer]);
  const loadExamples = (0, _react.useCallback)(() => {
    inferrer.setInputText([]);
    if (selectedField !== undefined && selectedDataView !== null) {
      (0, _rxjs.firstValueFrom)(search({
        params: {
          index: selectedDataView.getIndexPattern(),
          body: {
            fields: [selectedField],
            query: {
              function_score: {
                functions: [{
                  random_score: {}
                }]
              }
            }
          }
        }
      })).then(resp => {
        const tempExamples = resp.rawResponse.hits.hits.filter(({
          fields
        }) => (0, _mlIsPopulatedObject.isPopulatedObject)(fields, [selectedField])).map(({
          fields
        }) => fields[selectedField][0]);
        inferrer.setInputText(tempExamples);
      });
    }
  }, [inferrer, selectedDataView, search, selectedField]);
  (0, _react.useEffect)(function loadFieldNames() {
    if (selectedDataView !== null) {
      const tempFieldNames = selectedDataView.fields.filter(({
        displayName,
        esTypes
      }) => esTypes && esTypes.includes('text') && !['_id', '_index'].includes(displayName)).sort((a, b) => a.displayName.localeCompare(b.displayName)).map(({
        displayName
      }) => ({
        value: displayName,
        text: displayName
      }));
      setFieldNames(tempFieldNames);
      const fieldName = tempFieldNames.length === 1 ? tempFieldNames[0].value : undefined;
      inferrer.setInputField(fieldName);
    }
  }, [selectedDataView, inferrer]);
  (0, _react.useEffect)(function loadExamplesAfterFieldChange() {
    loadExamples();
  },
  // only load examples if selectedField changes
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedField]);
  function reloadExamples() {
    inferrer.reset();
    loadExamples();
  }
  return {
    fieldNames,
    dataViewListItems,
    reloadExamples,
    selectedDataViewId,
    setSelectedDataViewId,
    selectedField,
    setSelectedField
  };
}