"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaObjectList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaObjectList = /*#__PURE__*/(0, _react.memo)(({
  objectType,
  kibanaObjects,
  isSaving
}) => {
  const kibanaObjectLabels = {
    dashboard: _i18n.i18n.translate('xpack.ml.newJob.recognize.dashboardsLabel', {
      defaultMessage: 'Dashboards'
    }),
    search: _i18n.i18n.translate('xpack.ml.newJob.recognize.searchesLabel', {
      defaultMessage: 'Searches'
    }),
    visualization: _i18n.i18n.translate('xpack.ml.newJob.recognize.visualizationsLabel', {
      defaultMessage: 'Visualizations'
    })
  };
  if (kibanaObjects === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, kibanaObjectLabels[objectType])), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", null, kibanaObjects.map(({
    id,
    title,
    success,
    exists,
    error
  }, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: exists ? 'subdued' : 'success'
  }, title), success === false && error !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, (0, _mlErrorUtils.extractErrorMessage)(error))), exists && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "default"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.alreadyExistsLabel",
    defaultMessage: "(already exists)"
  }))))), !exists && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '60px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, isSaving ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : null, success !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: success ? 'check' : 'cross',
    color: success ? 'success' : 'danger',
    "aria-label": success ? _i18n.i18n.translate('xpack.ml.newJob.recognize.results.savedAriaLabel', {
      defaultMessage: 'Saved'
    }) : _i18n.i18n.translate('xpack.ml.newJob.recognize.results.saveFailedAriaLabel', {
      defaultMessage: 'Save failed'
    })
  }) : null))), (kibanaObjects.length === 1 || i < kibanaObjects.length - 1) && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })))));
});
exports.KibanaObjectList = KibanaObjectList;