"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fieldTypes = require("@kbn/field-types");
var _kibana = require("../../../../contexts/kibana");
var _ml = require("../../../../contexts/ml");
var _data_recognizer = require("../../../../components/data_recognizer");
var _recently_accessed = require("../../../../util/recently_accessed");
var _index_utils = require("../../../../util/index_utils");
var _link_card = require("../../../../components/link_card");
var _categorization_job_icon = require("./categorization_job_icon");
var _locator = require("../../../../../../common/constants/locator");
var _rare_job_icon = require("./rare_job_icon");
var _geo_job_icon = require("./geo_job_icon");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _page_header = require("../../../../components/page_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Page = () => {
  var _selectedSavedSearch$, _selectedSavedSearch$2;
  const {
    services: {
      share
    }
  } = (0, _kibana.useMlKibana)();
  const dataSourceContext = (0, _ml.useDataSource)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const onSelectDifferentIndex = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX);
  const [recognizerResultsCount, setRecognizerResultsCount] = (0, _react.useState)(0);
  const {
    selectedDataView,
    selectedSavedSearch
  } = dataSourceContext;
  const isTimeBasedIndex = (0, _index_utils.timeBasedIndexCheck)(selectedDataView);
  const hasGeoFields = (0, _react.useMemo)(() => [...selectedDataView.fields.getByType(_fieldTypes.ES_FIELD_TYPES.GEO_POINT), ...selectedDataView.fields.getByType(_fieldTypes.ES_FIELD_TYPES.GEO_SHAPE)].length > 0, [selectedDataView]);
  const indexWarningTitle = !isTimeBasedIndex && selectedSavedSearch ? _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataViewFromSavedSearchNotTimeBasedMessage', {
    defaultMessage: '{savedSearchTitle} uses data view {dataViewName} which is not time based',
    values: {
      savedSearchTitle: (_selectedSavedSearch$ = selectedSavedSearch.title) !== null && _selectedSavedSearch$ !== void 0 ? _selectedSavedSearch$ : '',
      dataViewName: selectedDataView.getName()
    }
  }) : _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataViewNotTimeBasedMessage', {
    defaultMessage: 'Data view {dataViewName} is not time based',
    values: {
      dataViewName: selectedDataView.getName()
    }
  });
  const pageTitleLabel = selectedSavedSearch ? _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.savedSearchPageTitleLabel', {
    defaultMessage: 'saved search {savedSearchTitle}',
    values: {
      savedSearchTitle: (_selectedSavedSearch$2 = selectedSavedSearch.title) !== null && _selectedSavedSearch$2 !== void 0 ? _selectedSavedSearch$2 : ''
    }
  }) : _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataViewPageTitleLabel', {
    defaultMessage: 'data view {dataViewName}',
    values: {
      dataViewName: selectedDataView.getName()
    }
  });
  const recognizerResults = {
    count: 0,
    onChange() {
      setRecognizerResultsCount(recognizerResults.count);
    }
  };
  const getUrlParams = () => {
    return !selectedSavedSearch ? `?index=${selectedDataView.id}` : `?savedSearchId=${selectedSavedSearch.id}`;
  };
  const addSelectionToRecentlyAccessed = async () => {
    var _selectedSavedSearch$3;
    const title = !selectedSavedSearch ? selectedDataView.getName() : (_selectedSavedSearch$3 = selectedSavedSearch.title) !== null && _selectedSavedSearch$3 !== void 0 ? _selectedSavedSearch$3 : '';
    const mlLocator = share.url.locators.get(_locator.ML_APP_LOCATOR);
    const dataVisualizerLink = await mlLocator.getUrl({
      page: _locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER,
      pageState: {
        ...(selectedSavedSearch !== null && selectedSavedSearch !== void 0 && selectedSavedSearch.id ? {
          savedSearchId: selectedSavedSearch.id
        } : {
          index: selectedDataView.id
        })
      }
    }, {
      absolute: true
    });
    (0, _recently_accessed.addItemToRecentlyAccessed)(_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER, title, dataVisualizerLink);
    navigateToPath(`/jobs/new_job/datavisualizer${getUrlParams()}`);
  };
  const jobTypes = [{
    onClick: () => navigateToPath(`/jobs/new_job/single_metric${getUrlParams()}`),
    icon: {
      type: 'createSingleMetricJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.singleMetricAriaLabel', {
        defaultMessage: 'Single metric job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.singleMetricTitle', {
      defaultMessage: 'Single metric'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.singleMetricDescription', {
      defaultMessage: 'Detect anomalies in a single time series.'
    }),
    id: 'mlJobTypeLinkSingleMetricJob'
  }, {
    onClick: () => navigateToPath(`/jobs/new_job/multi_metric${getUrlParams()}`),
    icon: {
      type: 'createMultiMetricJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.multiMetricAriaLabel', {
        defaultMessage: 'Multi-metric job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.multiMetricTitle', {
      defaultMessage: 'Multi-metric'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.multiMetricDescription', {
      defaultMessage: 'Detect anomalies with one or more metrics and optionally split the analysis.'
    }),
    id: 'mlJobTypeLinkMultiMetricJob'
  }, {
    onClick: () => navigateToPath(`/jobs/new_job/population${getUrlParams()}`),
    icon: {
      type: 'createPopulationJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.populationAriaLabel', {
        defaultMessage: 'Population job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.populationTitle', {
      defaultMessage: 'Population'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.populationDescription', {
      defaultMessage: 'Detect unusual activity in a population. Recommended for high cardinality data.'
    }),
    id: 'mlJobTypeLinkPopulationJob'
  }, {
    onClick: () => navigateToPath(`/jobs/new_job/advanced${getUrlParams()}`),
    icon: {
      type: 'createAdvancedJob',
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.advancedAriaLabel', {
        defaultMessage: 'Advanced job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.advancedTitle', {
      defaultMessage: 'Advanced'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.advancedDescription', {
      defaultMessage: 'Use the full range of options to create a job for more advanced use cases.'
    }),
    id: 'mlJobTypeLinkAdvancedJob'
  }, {
    onClick: () => navigateToPath(`/jobs/new_job/categorization${getUrlParams()}`),
    icon: {
      type: _categorization_job_icon.CategorizationIcon,
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.categorizationAriaLabel', {
        defaultMessage: 'Categorization job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.categorizationTitle', {
      defaultMessage: 'Categorization'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.categorizationDescription', {
      defaultMessage: 'Group log messages into categories and detect anomalies within them.'
    }),
    id: 'mlJobTypeLinkCategorizationJob'
  }, {
    onClick: () => navigateToPath(`/jobs/new_job/rare${getUrlParams()}`),
    icon: {
      type: _rare_job_icon.RareIcon,
      ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.rareAriaLabel', {
        defaultMessage: 'Rare job'
      })
    },
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.rareTitle', {
      defaultMessage: 'Rare'
    }),
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.rareDescription', {
      defaultMessage: 'Detect rare values in time series data.'
    }),
    id: 'mlJobTypeLinkrareJob'
  }];
  if (hasGeoFields) {
    jobTypes.push({
      onClick: () => navigateToPath(`/jobs/new_job/geo${getUrlParams()}`),
      icon: {
        type: _geo_job_icon.GeoIcon,
        ariaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.geoAriaLabel', {
          defaultMessage: 'Geo job'
        })
      },
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.geoTitle', {
        defaultMessage: 'Geo'
      }),
      description: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.geoDescription', {
        defaultMessage: 'Detect anomalies in the geographic location of the data.'
      }),
      id: 'mlJobTypeLinkGeoJob'
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageJobTypeSelection"
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.createJobFromTitle",
    defaultMessage: "Create a job from the {pageTitleLabel}",
    values: {
      pageTitleLabel
    }
  })), isTimeBasedIndex === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: indexWarningTitle,
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.howToRunAnomalyDetectionDescription",
    defaultMessage: "Anomaly detection can only be run over indices which are time based."
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onSelectDifferentIndex
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.selectDifferentIndexLinkText",
    defaultMessage: "Select a different data view or saved search"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement("div", {
    hidden: recognizerResultsCount === 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.useSuppliedConfigurationTitle",
    defaultMessage: "Use preconfigured jobs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.useSuppliedConfigurationDescription",
    defaultMessage: "The fields in your data match known configurations. Create a set of preconfigured jobs."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_data_recognizer.DataRecognizer, {
    indexPattern: selectedDataView,
    savedSearch: selectedSavedSearch,
    results: recognizerResults
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.useWizardTitle",
    defaultMessage: "Use a wizard"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4
  }, jobTypes.map(({
    onClick,
    icon,
    title,
    description,
    id
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id
  }, /*#__PURE__*/_react.default.createElement(_link_card.LinkCard, {
    "data-test-subj": id,
    onClick: onClick,
    icon: icon.type,
    iconAreaLabel: icon.ariaLabel,
    title: title,
    description: description,
    isDisabled: !isTimeBasedIndex
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.learnMoreAboutDataTitle",
    defaultMessage: "Learn more about your data"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobType.learnMoreAboutDataDescription",
    defaultMessage: "If you're not sure what type of job to create, first explore the fields and metrics in your data."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_link_card.LinkCard, {
    icon: "dataVisualizer",
    iconAreaLabel: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobType.dataVisualizerAriaLabel', {
      defaultMessage: 'Data Visualizer'
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobType.dataVisualizerTitle",
      defaultMessage: "Data Visualizer"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobType.dataVisualizerDescription",
      defaultMessage: "Learn more about the characteristics of your data and identify the fields for analysis with machine learning."
    }),
    onClick: addSelectionToRecentlyAccessed
  }))));
};
exports.Page = Page;