"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardNav = exports.PreviousButton = exports.NextButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WizardNav = ({
  previous,
  previousActive = true,
  next,
  nextActive = true,
  children
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, previous && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(PreviousButton, {
  previous: previous,
  previousActive: previousActive
})), next && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(NextButton, {
  next: next,
  nextActive: nextActive
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)));
exports.WizardNav = WizardNav;
const PreviousButton = ({
  previous,
  previousActive = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  disabled: !previousActive,
  onClick: previous,
  iconType: "arrowLeft",
  iconSide: "left",
  "data-test-subj": "mlJobWizardNavButtonPrevious"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.previousStepButton",
  defaultMessage: "Previous"
}));
exports.PreviousButton = PreviousButton;
const NextButton = ({
  next,
  nextActive = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  fill: true,
  disabled: !nextActive,
  onClick: next,
  iconSide: "right",
  iconType: "arrowRight",
  "data-test-subj": "mlJobWizardNavButtonNext"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.nextStepButton",
  defaultMessage: "Next"
}));
exports.NextButton = NextButton;