"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _app = require("../../../../../../../common/constants/app");
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _ml = require("../../../../../contexts/ml");
var _event_rate_chart = require("../charts/event_rate_chart");
var _new_job = require("../../../../../../../common/constants/new_job");
var _components = require("../../../common/components");
var _kibana = require("../../../../../contexts/kibana");
var _storage = require("../../../../../../../common/types/storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeRangeStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const dataSourceContext = (0, _ml.useDataSource)();
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    chartLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [timeRange, setTimeRange] = (0, _react.useState)({
    start: jobCreator.start,
    end: jobCreator.end
  });
  const [eventRateChartData, setEventRateChartData] = (0, _react.useState)([]);
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.ML_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  async function loadChart() {
    setLoadingData(true);
    try {
      var _jobCreator$runtimeMa;
      const resp = await chartLoader.loadEventRateChart(jobCreator.start, jobCreator.end, chartInterval.getInterval().asMilliseconds(), (_jobCreator$runtimeMa = jobCreator.runtimeMappings) !== null && _jobCreator$runtimeMa !== void 0 ? _jobCreator$runtimeMa : undefined, jobCreator.datafeedConfig.indices_options);
      setEventRateChartData(resp);
    } catch (error) {
      setEventRateChartData([]);
    }
    setLoadingData(false);
  }
  (0, _react.useEffect)(() => {
    const {
      start,
      end
    } = timeRange;
    jobCreator.setTimeRange(start, end);
    chartInterval.setBounds({
      min: (0, _moment.default)(start),
      max: (0, _moment.default)(end)
    });
    // update the timefilter, to keep the URL in sync
    const {
      timefilter: timefilterService
    } = services.data.query.timefilter;
    timefilterService.setTime({
      from: (0, _moment.default)(start).toISOString(),
      to: (0, _moment.default)(end).toISOString()
    });
    jobCreatorUpdate();
    loadChart();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator, chartInterval, timeRange.start, timeRange.end, jobCreatorUpdate, services.data.query.timefilter]);
  (0, _react.useEffect)(() => {
    setTimeRange({
      start: jobCreator.start,
      end: jobCreator.end
    });
  }, [jobCreator, jobCreatorUpdated]);
  function fullTimeRangeCallback(range) {
    if (range.start !== null && range.end !== null) {
      setTimeRange({
        start: range.start.epoch,
        end: range.end.epoch
      });
    } else {
      const {
        toasts
      } = services.notifications;
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.newJob.wizard.timeRangeStep.fullTimeRangeError', {
        defaultMessage: 'An error occurred obtaining the time range for the index'
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.TimeRangePicker, {
    setTimeRange: setTimeRange,
    timeRange: timeRange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
    frozenDataPreference: frozenDataPreference,
    setFrozenDataPreference: setFrozenDataPreference,
    dataView: dataSourceContext.selectedDataView,
    query: dataSourceContext.combinedQuery,
    disabled: false,
    callback: fullTimeRangeCallback,
    timefilter: timefilter,
    apiPath: `${_app.ML_INTERNAL_BASE_PATH}/fields_service/time_field_range`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateChartData,
    height: "300px",
    width: "100%",
    showAxis: true,
    loading: loadingData
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    next: () => setCurrentStep(jobCreator.type === _new_job.JOB_TYPE.ADVANCED ? _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED : _step_types.WIZARD_STEPS.PICK_FIELDS),
    nextActive: true
  })));
};
exports.TimeRangeStep = TimeRangeStep;