"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _job_creator = require("../../../../../common/job_creator");
var _ml_server_info = require("../../../../../../../services/ml_server_info");
var _common = require("../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobDetails = () => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  // TODO should use fieldFormats instead
  const dateFormat = uiSettings.get('dateFormat');
  const {
    anomaly_detectors: anomalyDetectors
  } = (0, _ml_server_info.getNewJobDefaults)();
  const isAdvanced = (0, _job_creator.isAdvancedJobCreator)(jobCreator);
  const modelMemoryLimitDefault = anomalyDetectors.model_memory_limit || '';
  const modelMemoryLimit = jobCreator.modelMemoryLimit !== null ? jobCreator.modelMemoryLimit : /*#__PURE__*/_react.default.createElement(_common.Italic, null, `${modelMemoryLimitDefault} (${_common.defaultLabel})`);
  const jobDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.jobDetails.title', {
      defaultMessage: 'Job ID'
    }),
    description: jobCreator.jobId
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.jobDescription.title', {
      defaultMessage: 'Job description'
    }),
    description: jobCreator.description.length > 0 ? jobCreator.description : /*#__PURE__*/_react.default.createElement(_common.Italic, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.jobDescription.placeholder",
      defaultMessage: "No description provided"
    }))
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.groups.title', {
      defaultMessage: 'Groups'
    }),
    description: jobCreator.groups.length > 0 ? jobCreator.groups.join(', ') : /*#__PURE__*/_react.default.createElement(_common.Italic, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.groups.placeholder",
      defaultMessage: "No groups selected"
    }))
  }];
  const detectorDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.bucketSpan.title', {
      defaultMessage: 'Bucket span'
    }),
    // @ts-expect-error bucketSpan is of type estypes.Duration
    description: jobCreator.bucketSpan
  }];
  if ((0, _job_creator.isMultiMetricJobCreator)(jobCreator)) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.splitField.title', {
        defaultMessage: 'Split field'
      }),
      description: (0, _job_creator.isMultiMetricJobCreator)(jobCreator) && jobCreator.splitField !== null ? jobCreator.splitField.name : /*#__PURE__*/_react.default.createElement(_common.Italic, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.splitField.placeholder",
        defaultMessage: "No split field selected"
      }))
    });
  }
  if ((0, _job_creator.isPopulationJobCreator)(jobCreator)) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.populationField.title', {
        defaultMessage: 'Population field'
      }),
      description: (0, _job_creator.isPopulationJobCreator)(jobCreator) && jobCreator.populationField !== null ? jobCreator.populationField.name : /*#__PURE__*/_react.default.createElement("span", {
        style: {
          fontStyle: jobCreator.populationField !== null ? 'inherit' : 'italic'
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.populationField.placeholder",
        defaultMessage: "No population field selected"
      }))
    });
  }
  if (isAdvanced && jobCreator.categorizationFieldName !== null) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.categorizationField.title', {
        defaultMessage: 'Categorization field'
      }),
      description: jobCreator.categorizationFieldName
    });
  }
  if (isAdvanced && jobCreator.summaryCountFieldName !== null) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.summaryCountField.title', {
        defaultMessage: 'Summary count field'
      }),
      description: jobCreator.summaryCountFieldName
    });
  }
  detectorDetails.push({
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.influencers.title', {
      defaultMessage: 'Influencers'
    }),
    description: jobCreator.influencers.length > 0 ? jobCreator.influencers.join(', ') : /*#__PURE__*/_react.default.createElement(_common.Italic, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.influencers.placeholder",
      defaultMessage: "No influencers selected"
    }))
  });
  const advancedDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.enableModelPlot.title', {
      defaultMessage: 'Enable model plot'
    }),
    description: jobCreator.modelPlot ? _common.trueLabel : _common.falseLabel
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.useDedicatedIndex.title', {
      defaultMessage: 'Use dedicated index'
    }),
    description: jobCreator.useDedicatedIndex ? _common.trueLabel : _common.falseLabel
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.modelMemoryLimit.title', {
      defaultMessage: 'Model memory limit'
    }),
    description: modelMemoryLimit
  }];
  const timeRangeDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.timeRange.start.title', {
      defaultMessage: 'Start'
    }),
    description: (0, _moment.default)(jobCreator.start).format(dateFormat)
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.timeRange.end.title', {
      defaultMessage: 'End'
    }),
    description: (0, _moment.default)(jobCreator.end).format(dateFormat)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: jobDetails
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detectorDetails
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedDetails
  })), isAdvanced === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: timeRangeDetails
  })));
};
exports.JobDetails = JobDetails;