"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationPerPartitionFieldDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../job_creator_context");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _categorization_per_partition_input = require("./categorization_per_partition_input");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationPerPartitionFieldDropdown = ({
  setEnablePerPartitionCategorization
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [categorizationPartitionFieldName, setCategorizationPartitionFieldName] = (0, _react.useState)(jobCreator.categorizationPerPartitionField);
  const {
    categoryFields
  } = _new_job_capabilities_service.newJobCapsService;
  const filteredCategories = (0, _react.useMemo)(() => categoryFields.filter(c => c.id !== jobCreator.categorizationFieldName),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [categoryFields, jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.categorizationPerPartitionField = categorizationPartitionFieldName;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [categorizationPartitionFieldName]);
  (0, _react.useEffect)(() => {
    // set the first item in category as partition field by default
    // because API requires partition_field to be defined in each detector with mlcategory
    // if per-partition categorization is enabled
    if (jobCreator.perPartitionCategorization && jobCreator.categorizationPerPartitionField === null && filteredCategories.length > 0) {
      jobCreator.categorizationPerPartitionField = filteredCategories[0].id;
    }
    setCategorizationPartitionFieldName(jobCreator.categorizationPerPartitionField);
    setEnablePerPartitionCategorization(jobCreator.perPartitionCategorization);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.extraStep.categorizationJob.categorizationPerPartitionFieldLabel",
      defaultMessage: "Partition field"
    })
  }, /*#__PURE__*/_react.default.createElement(_categorization_per_partition_input.CategorizationPerPartitionFieldSelect, {
    fields: filteredCategories,
    changeHandler: setCategorizationPartitionFieldName,
    selectedField: categorizationPartitionFieldName || ''
  }));
};
exports.CategorizationPerPartitionFieldDropdown = CategorizationPerPartitionFieldDropdown;