"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _string_utils = require("../../../../../../../util/string_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectorList = ({
  isActive,
  onEditJob,
  onDeleteJob
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [detectors, setDetectors] = (0, _react.useState)(jobCreator.detectors);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.duplicateDetectors);
  (0, _react.useEffect)(() => {
    setDetectors(jobCreator.detectors);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    if (!jobValidator.duplicateDetectors.valid) {
      setValidation(jobValidator.duplicateDetectors);
    }
    if (!jobValidator.categorizerVaryingPerPartitionField.valid) {
      setValidation(jobValidator.categorizerVaryingPerPartitionField);
    }
    if (!jobValidator.categorizerMissingPerPartition.valid) {
      setValidation(jobValidator.categorizerMissingPerPartition);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  const Buttons = ({
    index
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "primary",
      onClick: () => onEditJob(index),
      iconType: "pencil",
      "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorList.editButton', {
        defaultMessage: 'Edit'
      }),
      "data-test-subj": "mlAdvancedDetectorEditButton"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      onClick: () => onDeleteJob(index),
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorList.deleteButton', {
        defaultMessage: 'Delete'
      }),
      "data-test-subj": "mlAdvancedDetectorDeleteButton"
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorList.title",
    defaultMessage: "Detectors"
  }))), /*#__PURE__*/_react.default.createElement(NoDetectorsWarning, {
    show: detectors.length === 0
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, detectors.map((d, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    "data-test-subj": `mlAdvancedDetector ${i}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, d.detector_description !== undefined ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      fontWeight: 'bold'
    },
    "data-test-subj": "mlDetectorDescription"
  }, d.detector_description) : /*#__PURE__*/_react.default.createElement(StringifiedDetector, {
    detector: d
  })), isActive && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Buttons, {
    index: i
  }))), d.detector_description !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(StringifiedDetector, {
    detector: d
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(DetectorsValidationWarning, {
    validation: validation
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.DetectorList = DetectorList;
const NoDetectorsWarning = ({
  show
}) => {
  if (show === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.noDetectorsCallout.title', {
      defaultMessage: 'No detectors'
    }),
    iconType: "warning",
    "data-test-subj": "mlAdvancedNoDetectorsMessage"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.noDetectorsCallout.message",
    defaultMessage: "At least one detector is needed to create a job."
  })));
};
const DetectorsValidationWarning = ({
  validation
}) => {
  if (validation.valid === true) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: validation.message,
    isInvalid: validation.valid === false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)));
};
const StringifiedDetector = ({
  detector
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDetectorIdentifier"
  }, (0, _string_utils.detectorToString)(detector));
};