"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoreUnavailableSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IgnoreUnavailableSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [ignoreUnavailable, setIgnoreUnavailable] = (0, _react.useState)(jobCreator.ignoreUnavailable);
  (0, _react.useEffect)(() => {
    jobCreator.ignoreUnavailable = ignoreUnavailable;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ignoreUnavailable]);
  function toggleIgnoreUnavailable() {
    setIgnoreUnavailable(!ignoreUnavailable);
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "ignoreUnavailableSwitch",
    checked: ignoreUnavailable,
    onChange: toggleIgnoreUnavailable,
    "data-test-subj": "mlJobWizardSwitchIgnoreUnavailableIndex",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.ignoreUnavailable.title', {
      defaultMessage: 'Ignore unavailable indices'
    })
  }));
};
exports.IgnoreUnavailableSwitch = IgnoreUnavailableSwitch;