"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _ml_job_editor = require("../../../../../../jobs_list/components/ml_job_editor");
var _description = require("./description");
var _validation_utils = require("../../../../../../../../../common/util/validation_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITOR_HEIGHT = '400px';
const QueryInput = ({
  setIsValidQuery
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [queryString, setQueryString] = (0, _react.useState)(JSON.stringify(jobCreator.query, null, 2));
  (0, _react.useEffect)(() => {
    const validJson = (0, _validation_utils.isValidJson)(queryString);
    setIsValidQuery(validJson);
    if (validJson) {
      jobCreator.query = JSON.parse(queryString);
      jobCreatorUpdate();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [queryString]);
  (0, _react.useEffect)(() => {
    if ((0, _validation_utils.isValidJson)(queryString)) {
      // the query object may have changed outside of this component,
      // compare the current query with the local queryString by reformatting both
      const query = JSON.parse(queryString);
      const newQueryString = JSON.stringify(query, null, 2);
      const actualQuery = JSON.stringify(jobCreator.query, null, 2);
      if (newQueryString !== actualQuery) {
        setQueryString(actualQuery);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    const validJson = (0, _validation_utils.isValidJson)(queryString);
    setIsValidQuery(validJson);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  function onChange(qs) {
    setQueryString(qs);
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: queryString,
    height: EDITOR_HEIGHT,
    readOnly: false,
    onChange: onChange
  }));
};
exports.QueryInput = QueryInput;