"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimLanePagination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SwimLanePagination = ({
  cardinality,
  fromPage,
  perPage,
  onPaginationChange
}) => {
  const componentFromPage = fromPage - 1;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(() => !isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const goToPage = (0, _react.useCallback)(pageNumber => {
    onPaginationChange({
      fromPage: pageNumber + 1
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const setPerPage = (0, _react.useCallback)(perPageUpdate => {
    onPaginationChange({
      perPage: perPageUpdate
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const pageCount = Math.ceil(cardinality / perPage);
  const items = [5, 10, 20, 50, 100].map(v => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: `${v}_rows`,
      icon: v === perPage ? 'check' : 'empty',
      onClick: () => {
        closePopover();
        setPerPage(v);
      },
      "data-test-subj": `${v} rows`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.swimLaneSelectRowsPerPage",
      defaultMessage: "{rowsCount} rows",
      values: {
        rowsCount: v
      }
    }));
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onButtonClick,
      "data-test-subj": "mlSwimLanePageSizeControl"
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": perPage
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.swimLaneRowsPerPage",
      defaultMessage: "Rows per page: {rowsCount}",
      values: {
        rowsCount: perPage
      }
    }))),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "mlSwimLanePageSizePanel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.ml.explorer.swimLanePagination', {
      defaultMessage: 'Anomaly swim lane pagination'
    }),
    pageCount: pageCount,
    activePage: componentFromPage,
    onPageClick: goToPage,
    "data-test-subj": "mlSwimLanePagination"
  })));
};
exports.SwimLanePagination = SwimLanePagination;