"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopAnalytics = void 0;
var _i18n = require("@kbn/i18n");
var _dependency_cache = require("../../../../../util/dependency_cache");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _common = require("../../../../common");
var _common2 = require("../../components/analytics_list/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stopAnalytics = async d => {
  const toastNotifications = (0, _dependency_cache.getToastNotifications)();
  try {
    await _ml_api_service.ml.dataFrameAnalytics.stopDataFrameAnalytics(d.config.id, (0, _common2.isDataFrameAnalyticsFailed)(d.stats.state));
    toastNotifications.addSuccess(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.stopAnalyticsSuccessMessage', {
      defaultMessage: 'Request to stop data frame analytics {analyticsId} acknowledged.',
      values: {
        analyticsId: d.config.id
      }
    }));
  } catch (e) {
    toastNotifications.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.stopAnalyticsErrorMessage', {
      defaultMessage: 'An error occurred stopping the data frame analytics {analyticsId}: {error}',
      values: {
        analyticsId: d.config.id,
        error: JSON.stringify(e)
      }
    }));
  }
  _common.refreshAnalyticsList$.next(_common.REFRESH_ANALYTICS_LIST_STATE.REFRESH);
};
exports.stopAnalytics = stopAnalytics;