"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluateStat = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("../../../../common/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EvaluateStat = ({
  isLoading,
  title,
  description,
  dataTestSubj,
  tooltipContent
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
  reverse: true,
  isLoading: isLoading,
  title: title !== null ? Math.round(title * 1000) / 1000 : _analytics.EMPTY_STAT,
  description: description,
  titleSize: "xs"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  anchorClassName: "mlDataFrameAnalyticsRegression__evaluateStat",
  content: tooltipContent
})));
exports.EvaluateStat = EvaluateStat;