"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OTHER_CLASS_ID = exports.MAX_COLUMNS = exports.ACTUAL_CLASS_ID = void 0;
exports.getColumnData = getColumnData;
exports.getTrailingControlColumns = getTrailingControlColumns;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COL_INITIAL_WIDTH = 165; // in pixels

const ACTUAL_CLASS_ID = 'actual_class';
exports.ACTUAL_CLASS_ID = ACTUAL_CLASS_ID;
const OTHER_CLASS_ID = 'other';
exports.OTHER_CLASS_ID = OTHER_CLASS_ID;
const MAX_COLUMNS = 6;
exports.MAX_COLUMNS = MAX_COLUMNS;
function getColumnData(confusionMatrixData) {
  const colData = [];
  const columns = [{
    id: ACTUAL_CLASS_ID,
    display: /*#__PURE__*/_react.default.createElement("span", null),
    initialWidth: COL_INITIAL_WIDTH
  }];
  let showOther = false;
  for (const classData of confusionMatrixData) {
    const otherCount = classData.other_predicted_class_doc_count;
    if (otherCount > 0) {
      showOther = true;
    }
    const col = {
      actual_class: classData.actual_class,
      actual_class_doc_count: classData.actual_class_doc_count,
      other: otherCount,
      predicted_classes_count: {}
    };
    const predictedClasses = classData.predicted_classes || [];
    columns.push({
      id: classData.actual_class,
      initialWidth: COL_INITIAL_WIDTH
    });
    for (let i = 0; i < predictedClasses.length; i++) {
      const predictedClass = predictedClasses[i].predicted_class;
      const predictedClassCount = predictedClasses[i].count;
      col.predicted_classes_count[predictedClass] = predictedClassCount;
    }
    colData.push(col);
  }
  if (showOther) {
    columns.push({
      id: OTHER_CLASS_ID,
      initialWidth: COL_INITIAL_WIDTH
    });
  }
  return {
    columns,
    columnData: colData
  };
}
function getTrailingControlColumns(numColumns, setShowFullColumns) {
  return [{
    id: 'actions',
    width: 60,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement("span", null, `${numColumns} more`),
    rowCellRender: function RowCellRender() {
      const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        isOpen: isPopoverOpen,
        anchorPosition: "upCenter",
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.showActions', {
            defaultMessage: 'Show actions'
          }),
          iconType: "boxesHorizontal",
          color: "text",
          onClick: () => setIsPopoverOpen(!isPopoverOpen)
        }),
        closePopover: () => setIsPopoverOpen(false),
        ownFocus: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => setShowFullColumns(true)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        grow: false,
        textAlign: "center"
      }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.showAllColumns', {
        defaultMessage: 'Show all columns'
      }))));
    }
  }];
}