"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ace = require("@kbn/ace");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
var _ml = require("../../../../../contexts/ml");
var _runtime_mappings_editor = require("./runtime_mappings_editor");
var _switch_modal = require("./switch_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const advancedEditorsSidebarWidth = '220px';
const COPY_RUNTIME_FIELDS_TO_CLIPBOARD_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.indexPreview.copyRuntimeMappingsClipboardTooltip', {
  defaultMessage: 'Copy Dev Console statement of the runtime fields to the clipboard.'
});
const APPLY_CHANGES_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.advancedSourceEditorApplyButtonText', {
  defaultMessage: 'Apply changes'
});
const RUNTIME_FIELDS_EDITOR_HELP_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.advancedRuntimeFieldsEditorHelpText', {
  defaultMessage: 'The advanced editor allows you to edit the runtime fields of the source.'
});
const EDIT_SWITCH_LABEL_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.advancedEditorRuntimeFieldsSwitchLabel', {
  defaultMessage: 'Edit runtime fields'
});
const RUNTIME_FIELDS_LABEL_TEXT = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeFieldsLabel', {
  defaultMessage: 'Runtime fields'
});
const {
  useXJsonMode
} = _public.XJson;
const xJsonMode = new _ace.XJsonMode();
const RuntimeMappings = ({
  actions,
  state
}) => {
  const [isRuntimeMappingsEditorEnabled, setIsRuntimeMappingsEditorEnabled] = (0, _react.useState)(false);
  const [isRuntimeMappingsEditorSwitchModalVisible, setRuntimeMappingsEditorSwitchModalVisible] = (0, _react.useState)(false);
  const [isRuntimeMappingsEditorApplyButtonEnabled, setIsRuntimeMappingsEditorApplyButtonEnabled] = (0, _react.useState)(false);
  const [advancedEditorRuntimeMappingsLastApplied, setAdvancedEditorRuntimeMappingsLastApplied] = (0, _react.useState)();
  const {
    setFormState
  } = actions;
  const {
    jobType,
    previousRuntimeMapping,
    runtimeMappings
  } = state.form;
  const {
    convertToJson,
    setXJson: setAdvancedRuntimeMappingsConfig,
    xJson: advancedRuntimeMappingsConfig
  } = useXJsonMode(runtimeMappings || '');
  const {
    selectedDataView
  } = (0, _ml.useDataSource)();
  const applyChanges = () => {
    const removeRuntimeMappings = advancedRuntimeMappingsConfig === '';
    const parsedRuntimeMappings = removeRuntimeMappings ? undefined : JSON.parse(advancedRuntimeMappingsConfig);
    const prettySourceConfig = removeRuntimeMappings ? '' : JSON.stringify(parsedRuntimeMappings, null, 2);
    const previous = previousRuntimeMapping === undefined && runtimeMappings === undefined ? parsedRuntimeMappings : runtimeMappings;
    setFormState({
      runtimeMappings: parsedRuntimeMappings,
      runtimeMappingsUpdated: true,
      previousRuntimeMapping: previous
    });
    setAdvancedRuntimeMappingsConfig(prettySourceConfig);
    setAdvancedEditorRuntimeMappingsLastApplied(prettySourceConfig);
    setIsRuntimeMappingsEditorApplyButtonEnabled(false);
  };
  const toggleEditorHandler = (reset = false) => {
    if (reset === true) {
      setFormState({
        runtimeMappingsUpdated: false
      });
      setAdvancedRuntimeMappingsConfig(advancedEditorRuntimeMappingsLastApplied !== null && advancedEditorRuntimeMappingsLastApplied !== void 0 ? advancedEditorRuntimeMappingsLastApplied : '');
    }
    setIsRuntimeMappingsEditorEnabled(!isRuntimeMappingsEditorEnabled);
    setIsRuntimeMappingsEditorApplyButtonEnabled((0, _mlRuntimeFieldUtils.isRuntimeMappings)(runtimeMappings));
  };
  (0, _react.useEffect)(function getInitialRuntimeMappings() {
    const combinedRuntimeMappings = (0, _mlRuntimeFieldUtils.getCombinedRuntimeMappings)(selectedDataView, runtimeMappings);
    const prettySourceConfig = JSON.stringify(combinedRuntimeMappings, null, 2);
    if (combinedRuntimeMappings) {
      setAdvancedRuntimeMappingsConfig(prettySourceConfig);
      setAdvancedEditorRuntimeMappingsLastApplied(prettySourceConfig);
      setFormState({
        runtimeMappings: combinedRuntimeMappings
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: RUNTIME_FIELDS_LABEL_TEXT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, (0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    grow: false
  }, Object.keys(runtimeMappings).join(',')) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.createWizard.noRuntimeFieldLabel",
    defaultMessage: "No runtime field"
  }), isRuntimeMappingsEditorEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_runtime_mappings_editor.RuntimeMappingsEditor, {
    advancedEditorRuntimeMappingsLastApplied: advancedEditorRuntimeMappingsLastApplied,
    advancedRuntimeMappingsConfig: advancedRuntimeMappingsConfig,
    setIsRuntimeMappingsEditorApplyButtonEnabled: setIsRuntimeMappingsEditorApplyButtonEnabled,
    setAdvancedRuntimeMappingsConfig: setAdvancedRuntimeMappingsConfig,
    convertToJson: convertToJson,
    xJsonMode: xJsonMode
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: jobType === undefined,
    label: EDIT_SWITCH_LABEL_TEXT,
    checked: isRuntimeMappingsEditorEnabled,
    onChange: () => {
      if (isRuntimeMappingsEditorEnabled && advancedRuntimeMappingsConfig !== advancedEditorRuntimeMappingsLastApplied) {
        setRuntimeMappingsEditorSwitchModalVisible(true);
        return;
      }
      toggleEditorHandler();
    },
    "data-test-subj": "mlDataFrameAnalyticsRuntimeMappingsEditorSwitch"
  }), isRuntimeMappingsEditorSwitchModalVisible && /*#__PURE__*/_react.default.createElement(_switch_modal.SwitchModal, {
    onCancel: () => setRuntimeMappingsEditorSwitchModalVisible(false),
    onConfirm: () => {
      setRuntimeMappingsEditorSwitchModalVisible(false);
      toggleEditorHandler(true);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: COPY_RUNTIME_FIELDS_TO_CLIPBOARD_TEXT,
    textToCopy: advancedRuntimeMappingsConfig !== null && advancedRuntimeMappingsConfig !== void 0 ? advancedRuntimeMappingsConfig : ''
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": COPY_RUNTIME_FIELDS_TO_CLIPBOARD_TEXT
  }))))), isRuntimeMappingsEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, RUNTIME_FIELDS_EDITOR_HELP_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applyChanges,
    disabled: !isRuntimeMappingsEditorApplyButtonEnabled,
    "data-test-subj": "mlDataFrameAnalyticsRuntimeMappingsApplyButton"
  }, APPLY_CHANGES_TEXT)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.RuntimeMappings = RuntimeMappings;