"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _description = require("./description");
var _custom_urls = require("../../../../../components/custom_urls");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buttonContent = _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.detailsStep.additionalSectionButton', {
  defaultMessage: 'Additional settings'
});
const AdditionalSection = ({
  formState,
  setFormState
}) => {
  var _formMeta$custom_urls;
  const [additionalExpanded, setAdditionalExpanded] = (0, _react.useState)(false);
  const {
    _meta: formMeta
  } = formState;
  const analyticsJob = (0, _react.useMemo)(() => (0, _state.getJobConfigFromFormState)(formState), [formState]);
  const setCustomUrls = urls => {
    setFormState({
      _meta: {
        ...formMeta,
        custom_urls: urls
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "additional-section",
    buttonContent: buttonContent,
    onToggle: setAdditionalExpanded,
    initialIsOpen: additionalExpanded,
    "data-test-subj": "mlJobWizardToggleAdditionalSettingsSection"
  }, /*#__PURE__*/_react.default.createElement("section", {
    "data-test-subj": "mlDataFrameAnalyticsDetailsStepAdditionalSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_custom_urls.CustomUrlsWrapper, {
    job: analyticsJob,
    jobCustomUrls: (_formMeta$custom_urls = formMeta === null || formMeta === void 0 ? void 0 : formMeta.custom_urls) !== null && _formMeta$custom_urls !== void 0 ? _formMeta$custom_urls : [],
    setCustomUrls: setCustomUrls,
    editMode: "modal",
    isPartialDFAJob: true
  })))));
};
exports.AdditionalSection = AdditionalSection;