"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutlierHyperParameters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _advanced_step_form = require("./advanced_step_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutlierHyperParameters = ({
  actions,
  state,
  advancedParamErrors
}) => {
  const {
    setFormState
  } = actions;
  const {
    method,
    nNeighbors,
    outlierFraction,
    standardizationEnabled
  } = state.form;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.methodLabel', {
      defaultMessage: 'Method'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.methodHelpText', {
      defaultMessage: 'Set the method that outlier detection uses. If not set, uses an ensemble of different methods, normalizes and combines their individual outlier scores to obtain the overall outlier score. It is recommended to use the ensemble method.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.METHOD] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.METHOD]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: Object.values(_mlDataFrameAnalyticsUtils.OUTLIER_ANALYSIS_METHOD).map(outlierMethod => ({
      value: outlierMethod,
      text: outlierMethod
    })),
    value: method,
    hasNoInitialSelection: true,
    onChange: e => {
      setFormState({
        method: e.target.value
      });
    },
    "data-test-subj": "mlAnalyticsCreateJobWizardMethodInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.nNeighborsLabel', {
      defaultMessage: 'N neighbors'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.nNeighborsHelpText', {
      defaultMessage: 'The value for how many nearest neighbors each method of outlier detection uses to calculate its outlier score. When not set, different values are used for different ensemble members. Must be a positive integer.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.N_NEIGHBORS] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.N_NEIGHBORS]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.nNeighborsInputAriaLabel', {
      defaultMessage: 'The value for how many nearest neighbors each method of outlier detection uses to calculate its outlier score.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardnNeighborsInput",
    onChange: e => setFormState({
      nNeighbors: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 1,
    min: 1,
    value: (0, _advanced_step_form.getNumberValue)(nNeighbors)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierFractionLabel', {
      defaultMessage: 'Outlier fraction'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierFractionHelpText', {
      defaultMessage: 'Set the proportion of the data set that is assumed to be outlying prior to outlier detection.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.OUTLIER_FRACTION] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.OUTLIER_FRACTION]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierFractionInputAriaLabel', {
      defaultMessage: 'Sets the proportion of the data set that is assumed to be outlying prior to outlier detection.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardoutlierFractionInput",
    onChange: e => setFormState({
      outlierFraction: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(outlierFraction)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledLabel', {
      defaultMessage: 'Standardization enabled'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledHelpText', {
      defaultMessage: 'If true, the following operation is performed on the columns before computing outlier scores: (x_i - mean(x_i)) / sd(x_i).'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledInputAriaLabel', {
      defaultMessage: 'Sets standardization enabled setting.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardStandardizationEnabledInput",
    options: [{
      value: 'true',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledTrueValue', {
        defaultMessage: 'True'
      })
    }, {
      value: 'false',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledFalseValue', {
        defaultMessage: 'False'
      })
    }],
    value: standardizationEnabled,
    hasNoInitialSelection: true,
    onChange: e => {
      setFormState({
        standardizationEnabled: e.target.value
      });
    }
  }))));
};
exports.OutlierHyperParameters = OutlierHyperParameters;