"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedStepForm = void 0;
exports.getNumberValue = getNumberValue;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _hyper_parameters = require("./hyper_parameters");
var _reducer = require("../../../analytics_management/hooks/use_create_analytics_form/reducer");
var _kibana = require("../../../../../contexts/kibana");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _page = require("../../page");
var _shared = require("../shared");
var _continue_button = require("../continue_button");
var _outlier_hyper_parameters = require("./outlier_hyper_parameters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultNumTopClassesOption = {
  label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.allClassesLabel', {
    defaultMessage: 'All classes'
  }),
  value: -1
};
const numClassesTypeMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.dataframe.analytics.create.numTopClassTypeWarning",
  defaultMessage: "Value must be an integer of -1 or greater, where -1 indicates all classes."
});
function getZeroClassesMessage(elasticUrl) {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.zeroClassesMessage",
    defaultMessage: "To evaluate the {wikiLink}, select all classes or a value greater than the total number of categories.",
    values: {
      wikiLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: elasticUrl,
        target: "_blank",
        external: true
      }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.aucRocLabel', {
        defaultMessage: 'AUC ROC'
      }))
    }
  });
}
function getTopClassesHelpText(currentNumTopClasses) {
  if (currentNumTopClasses === -1) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.create.numTopClassesHelpText",
      defaultMessage: "The number of categories for which the predicted probabilities are reported."
    }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.create.allClassesMessage",
      defaultMessage: "If you have a large number of classes there could be a significant effect on the size of your destination index."
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.numTopClassesHelpText",
    defaultMessage: "The number of categories for which the predicted probabilities are reported."
  });
}
function getSelectedNumTomClassesOption(currentNumTopClasses) {
  const option = [];
  if (currentNumTopClasses === -1) {
    option.push(defaultNumTopClassesOption);
  } else if (currentNumTopClasses !== undefined) {
    option.push({
      label: `${currentNumTopClasses}`
    });
  }
  return option;
}
function isInvalidNumTopClasses(currentNumTopClasses) {
  // Only valid if undefined or a whole integer >= -1
  return currentNumTopClasses !== undefined && (isNaN(currentNumTopClasses) || currentNumTopClasses < -1 || currentNumTopClasses - Math.floor(currentNumTopClasses) !== 0);
}
function getNumberValue(value) {
  return value === undefined ? '' : +value;
}
const AdvancedStepForm = ({
  actions,
  state,
  setCurrentStep
}) => {
  var _numTopClassesSelecte;
  const [advancedParamErrors, setAdvancedParamErrors] = (0, _react.useState)({});
  const [fetchingAdvancedParamErrors, setFetchingAdvancedParamErrors] = (0, _react.useState)(false);
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const classAucRocDocLink = docLinks.links.ml.classificationAucRoc;
  const {
    setEstimatedModelMemoryLimit,
    setFormState
  } = actions;
  const {
    form,
    isJobCreated,
    estimatedModelMemoryLimit
  } = state;
  const {
    alpha,
    computeFeatureInfluence,
    downsampleFactor,
    eta,
    etaGrowthRatePerTree,
    featureBagFraction,
    featureInfluenceThreshold,
    gamma,
    jobType,
    lambda,
    maxNumThreads,
    maxOptimizationRoundsPerHyperparameter,
    maxTrees,
    method,
    modelMemoryLimit,
    modelMemoryLimitValidationResult,
    nNeighbors,
    numTopClasses,
    numTopFeatureImportanceValues,
    numTopFeatureImportanceValuesValid,
    outlierFraction,
    predictionFieldName,
    randomizeSeed,
    softTreeDepthLimit,
    softTreeDepthTolerance,
    useEstimatedMml
  } = form;
  const [numTopClassesOptions, setNumTopClassesOptions] = (0, _react.useState)([defaultNumTopClassesOption]);
  const [numTopClassesSelectedOptions, setNumTopClassesSelectedOptions] = (0, _react.useState)(getSelectedNumTomClassesOption(numTopClasses));
  const selectedNumTopClasses = numTopClassesSelectedOptions[0] && ((_numTopClassesSelecte = numTopClassesSelectedOptions[0].value) !== null && _numTopClassesSelecte !== void 0 ? _numTopClassesSelecte : Number(numTopClassesSelectedOptions[0].label));
  const selectedNumTopClassesIsInvalid = isInvalidNumTopClasses(selectedNumTopClasses);
  const mmlErrors = (0, _react.useMemo)(() => (0, _reducer.getModelMemoryLimitErrors)(modelMemoryLimitValidationResult), [modelMemoryLimitValidationResult]);
  const isRegOrClassJob = jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION;
  const mmlInvalid = modelMemoryLimitValidationResult !== null && (modelMemoryLimitValidationResult.invalidUnits !== undefined || modelMemoryLimitValidationResult.required === true);
  const isStepInvalid = selectedNumTopClassesIsInvalid || mmlInvalid || Object.keys(advancedParamErrors).length > 0 || fetchingAdvancedParamErrors === true || maxNumThreads === 0;
  (0, _react.useEffect)(() => {
    setFetchingAdvancedParamErrors(true);
    (async function () {
      const {
        success,
        errorMessage,
        errorReason,
        expectedMemory
      } = await (0, _shared.fetchExplainData)(form);
      const paramErrors = {};
      if (success) {
        if (modelMemoryLimit !== expectedMemory) {
          setEstimatedModelMemoryLimit(expectedMemory);
          if (useEstimatedMml === true) {
            setFormState({
              modelMemoryLimit: expectedMemory
            });
          }
        }
      } else {
        // Check which field is invalid
        Object.values(_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS).forEach(param => {
          if (errorMessage.includes(`[${param}]`)) {
            paramErrors[param] = errorMessage;
          } else if (errorReason !== null && errorReason !== void 0 && errorReason.includes(`[${param}]`)) {
            paramErrors[param] = errorReason;
          }
        });
      }
      setFetchingAdvancedParamErrors(false);
      setAdvancedParamErrors(paramErrors);
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [alpha, downsampleFactor, eta, etaGrowthRatePerTree, featureBagFraction, featureInfluenceThreshold, gamma, lambda, maxNumThreads, maxOptimizationRoundsPerHyperparameter, maxTrees, method, nNeighbors, numTopClasses, numTopFeatureImportanceValues, outlierFraction, randomizeSeed, softTreeDepthLimit, softTreeDepthTolerance, useEstimatedMml]);
  const outlierDetectionAdvancedConfig = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.computeFeatureInfluenceLabel', {
      defaultMessage: 'Compute feature influence'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.computeFeatureInfluenceLabelHelpText', {
      defaultMessage: 'Specify whether the feature influence calculation is enabled. Defaults to true.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "mlAnalyticsCreateJobWizardComputeFeatureInfluenceLabelInput",
    options: [{
      value: 'true',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.computeFeatureInfluenceTrueValue', {
        defaultMessage: 'True'
      })
    }, {
      value: 'false',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.computeFeatureInfluenceFalseValue', {
        defaultMessage: 'False'
      })
    }],
    value: computeFeatureInfluence,
    hasNoInitialSelection: false,
    onChange: e => {
      setFormState({
        computeFeatureInfluence: e.target.value
      });
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureInfluenceThresholdLabel', {
      defaultMessage: 'Feature influence threshold'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureInfluenceThresholdHelpText', {
      defaultMessage: 'The minimum outlier score that a document needs to have in order to calculate its feature influence score. Value range: 0-1. Defaults to 0.1.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.FEATURE_INFLUENCE_THRESHOLD] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.FEATURE_INFLUENCE_THRESHOLD]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    onChange: e => setFormState({
      featureInfluenceThreshold: e.target.value === '' ? undefined : +e.target.value
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardFeatureInfluenceThresholdInput",
    min: 0,
    max: 1,
    step: 0.001,
    value: getNumberValue(featureInfluenceThreshold)
  }))));
  const regAndClassAdvancedConfig = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.numTopFeatureImportanceValuesLabel', {
      defaultMessage: 'Feature importance values'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.numTopFeatureImportanceValuesHelpText', {
      defaultMessage: 'Specify the maximum number of feature importance values per document to return.'
    }),
    isInvalid: numTopFeatureImportanceValuesValid === false,
    error: [...(numTopFeatureImportanceValuesValid === false ? [/*#__PURE__*/_react.default.createElement(_react.Fragment, null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.numTopFeatureImportanceValuesErrorText', {
      defaultMessage: 'Invalid maximum number of feature importance values.'
    }))] : [])]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.numTopFeatureImportanceValuesInputAriaLabel', {
      defaultMessage: 'Maximum number of feature importance values per document.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobFlyoutnumTopFeatureImportanceValuesInput",
    isInvalid: numTopFeatureImportanceValuesValid === false,
    min: _mlDataFrameAnalyticsUtils.NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN,
    onChange: e => setFormState({
      numTopFeatureImportanceValues: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 1,
    value: getNumberValue(numTopFeatureImportanceValues)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.predictionFieldNameLabel', {
      defaultMessage: 'Prediction field name'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.predictionFieldNameHelpText', {
      defaultMessage: 'Define the name of the prediction field in the results. The default is <dependent_variable>_prediction.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: isJobCreated,
    value: predictionFieldName,
    onChange: e => setFormState({
      predictionFieldName: e.target.value
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardPredictionFieldNameInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.randomizeSeedLabel', {
      defaultMessage: 'Randomize seed'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.randomizeSeedText', {
      defaultMessage: 'The seed for the random generator used to pick training data.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.RANDOMIZE_SEED] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.RANDOMIZE_SEED]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.randomizeSeedInputAriaLabel', {
      defaultMessage: 'The seed for the random generator used to pick training data.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardRandomizeSeedInput",
    onChange: e => setFormState({
      randomizeSeed: e.target.value === '' ? undefined : +e.target.value
    }),
    isInvalid: randomizeSeed !== undefined && typeof randomizeSeed !== 'number',
    value: getNumberValue(randomizeSeed),
    step: 1
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedConfigSectionTitle', {
    defaultMessage: 'Advanced configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION && outlierDetectionAdvancedConfig, isRegOrClassJob && regAndClassAdvancedConfig, jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.numTopClassesLabel', {
      defaultMessage: 'Top classes'
    }),
    helpText: getTopClassesHelpText(selectedNumTopClasses),
    isInvalid: selectedNumTopClasses === 0 || selectedNumTopClassesIsInvalid,
    error: [...(selectedNumTopClasses === 0 ? [getZeroClassesMessage(classAucRocDocLink)] : []), ...(selectedNumTopClassesIsInvalid ? [numClassesTypeMessage] : [])]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.numTopClassesInputAriaLabel', {
      defaultMessage: 'The number of categories for which the predicted probabilities are reported'
    }),
    singleSelection: true,
    options: numTopClassesOptions,
    selectedOptions: numTopClassesSelectedOptions,
    onCreateOption: (input, flattenedOptions = []) => {
      const normalizedInput = input.trim().toLowerCase();
      if (normalizedInput === '') {
        return;
      }
      const newOption = {
        label: input
      };
      if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedInput) === -1) {
        setNumTopClassesOptions([...numTopClassesOptions, newOption]);
      }
      setNumTopClassesSelectedOptions([newOption]);
    },
    onChange: selectedOptions => {
      setNumTopClassesSelectedOptions(selectedOptions);
    },
    isClearable: true,
    isInvalid: selectedNumTopClasses !== undefined && selectedNumTopClasses < -1,
    "data-test-subj": "mlAnalyticsCreateJobWizardnumTopClassesInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.modelMemoryLimitLabel', {
      defaultMessage: 'Model memory limit'
    }),
    isInvalid: modelMemoryLimitValidationResult !== null,
    error: mmlErrors,
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.modelMemoryLimitHelpText', {
      defaultMessage: 'The approximate maximum amount of memory resources that are permitted for analytical processing.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: jobType !== undefined ? _state.DEFAULT_MODEL_MEMORY_LIMIT[jobType] : _state.DEFAULT_MODEL_MEMORY_LIMIT.outlier_detection,
    disabled: isJobCreated || useEstimatedMml,
    value: useEstimatedMml ? estimatedModelMemoryLimit : modelMemoryLimit || '',
    onChange: e => setFormState({
      modelMemoryLimit: e.target.value
    }),
    isInvalid: modelMemoryLimitValidationResult !== null,
    "data-test-subj": "mlAnalyticsCreateJobWizardModelMemoryInput"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: isJobCreated,
    name: "mlDataFrameAnalyticsUseEstimatedMml",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.useEstimatedMmlLabel', {
      defaultMessage: 'Use estimated model memory limit'
    }),
    checked: useEstimatedMml === true,
    onChange: () => setFormState({
      useEstimatedMml: !useEstimatedMml
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardUseEstimatedMml"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxNumThreadsLabel', {
      defaultMessage: 'Maximum number of threads'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxNumThreadsHelpText', {
      defaultMessage: 'The maximum number of threads to be used by the analysis. The default value is 1.'
    }),
    isInvalid: maxNumThreads === 0,
    error: maxNumThreads === 0 && _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxNumThreadsError', {
      defaultMessage: 'The minimum value is 1.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxNumThreadsInputAriaLabel', {
      defaultMessage: 'The maximum number of threads to be used by the analysis.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardMaxNumThreadsInput",
    min: 1,
    onChange: e => setFormState({
      maxNumThreads: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 1,
    value: getNumberValue(maxNumThreads)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "hyper-parameters",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.hyperParametersSectionTitle', {
      defaultMessage: 'Hyperparameters'
    }))),
    initialIsOpen: false,
    "data-test-subj": "mlAnalyticsCreateJobWizardHyperParametersSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION && /*#__PURE__*/_react.default.createElement(_outlier_hyper_parameters.OutlierHyperParameters, {
    actions: actions,
    state: state,
    advancedParamErrors: advancedParamErrors
  }), isRegOrClassJob && /*#__PURE__*/_react.default.createElement(_hyper_parameters.HyperParameters, {
    actions: actions,
    state: state,
    advancedParamErrors: advancedParamErrors
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_continue_button.ContinueButton, {
    isDisabled: isStepInvalid,
    onClick: () => {
      setFormState({
        numTopClasses: selectedNumTopClassesIsInvalid === false ? selectedNumTopClasses : undefined
      });
      setCurrentStep(_page.ANALYTICS_STEPS.DETAILS);
    }
  }));
};
exports.AdvancedStepForm = AdvancedStepForm;