"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJobSelectionFlyout = useJobSelectionFlyout;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana = require("../kibana");
var _job_selector_flyout = require("../../../embeddables/common/components/job_selector_flyout");
var _job_selector = require("../../components/job_selector/job_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for invoking Anomaly Detection jobs selection
 * inside the ML app.
 */
function useJobSelectionFlyout() {
  const {
    overlays,
    services
  } = (0, _kibana.useMlKibana)();
  const flyoutRef = (0, _react.useRef)();
  (0, _react.useEffect)(function closeFlyoutOnLeave() {
    return () => {
      if (flyoutRef.current) {
        flyoutRef.current.close();
      }
    };
  }, []);
  return (0, _react.useCallback)((config = {
    singleSelection: false,
    withTimeRangeSelector: true,
    timeseriesOnly: false
  }) => {
    const {
      uiSettings
    } = services;
    const tzConfig = uiSettings.get('dateFormat:tz');
    const dateFormatTz = tzConfig !== 'Browser' ? tzConfig : _moment.default.tz.guess();
    const maps = {
      groupsMap: (0, _job_selector.getInitialGroupsMap)([]),
      jobsMap: {}
    };
    return new Promise(async (resolve, reject) => {
      try {
        flyoutRef.current = overlays.openFlyout( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: services
        }, /*#__PURE__*/_react.default.createElement(_job_selector_flyout.JobSelectorFlyout, {
          selectedIds: [],
          withTimeRangeSelector: config.withTimeRangeSelector,
          dateFormatTz: dateFormatTz,
          singleSelection: !!config.singleSelection,
          timeseriesOnly: !!config.timeseriesOnly,
          onFlyoutClose: () => {
            reject();
            flyoutRef.current.close();
          },
          onSelectionConfirmed: payload => {
            resolve(payload);
            flyoutRef.current.close();
          },
          maps: maps
        })));
      } catch (error) {
        reject(error);
      }
    });
  }, [overlays, services]);
}