"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScopeExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering a rule scope expression.
 */

function getFilterListOptions(filterListIds) {
  return filterListIds.map(filterId => ({
    value: filterId,
    text: filterId
  }));
}
class ScopeExpression extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "openFilterList", () => {
      this.setState({
        isFilterListOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closeFilterList", () => {
      this.setState({
        isFilterListOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onChangeFilterType", event => {
      const {
        fieldName,
        filterId,
        enabled,
        updateScope
      } = this.props;
      updateScope(fieldName, filterId, event.target.value, enabled);
    });
    (0, _defineProperty2.default)(this, "onChangeFilterId", event => {
      const {
        fieldName,
        filterType,
        enabled,
        updateScope
      } = this.props;
      updateScope(fieldName, event.target.value, filterType, enabled);
    });
    (0, _defineProperty2.default)(this, "onEnableChange", event => {
      const {
        fieldName,
        filterId,
        filterType,
        updateScope
      } = this.props;
      updateScope(fieldName, filterId, filterType, event.target.checked);
    });
    this.state = {
      isFilterListOpen: false
    };
  }
  renderFilterListPopover() {
    const {
      filterId,
      filterType,
      filterListIds
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.scopeExpression.scopeFilterTypePopoverTitle",
      defaultMessage: "Is"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiExpression"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        maxWidth: 450
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 150
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: filterType,
      onChange: this.onChangeFilterType,
      options: [{
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.INCLUDE,
        text: (0, _utils.filterTypeToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.INCLUDE)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.EXCLUDE,
        text: (0, _utils.filterTypeToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.EXCLUDE)
      }]
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 300
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: filterId,
      onChange: this.onChangeFilterId,
      options: getFilterListOptions(filterListIds)
    })))));
  }
  render() {
    const {
      fieldName,
      filterId,
      filterType,
      enabled,
      filterListIds
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "scope-field-checkbox"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `scope_cb_${fieldName}`,
      checked: enabled,
      onChange: this.onEnableChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      className: "scope-field-button",
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.scopeExpression.scopeFieldWhenLabel",
        defaultMessage: "when"
      }),
      value: fieldName,
      isActive: false,
      onClick: event => event.preventDefault()
    })), filterListIds !== undefined && filterListIds.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "operatorValuePopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.scopeExpression.scopeFilterTypeButtonLabel",
          defaultMessage: "is {filterType}",
          values: {
            filterType: (0, _utils.filterTypeToText)(filterType)
          }
        }),
        value: filterId || '',
        isActive: this.state.isFilterListOpen,
        onClick: this.openFilterList
      }),
      isOpen: this.state.isFilterListOpen,
      closePopover: this.closeFilterList,
      panelPaddingSize: "s",
      ownFocus: true,
      anchorPosition: "downLeft"
    }, this.renderFilterListPopover())));
  }
}
exports.ScopeExpression = ScopeExpression;
ScopeExpression.propTypes = {
  fieldName: _propTypes.default.string.isRequired,
  filterId: _propTypes.default.string,
  filterType: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.INCLUDE, _mlAnomalyUtils.ML_DETECTOR_RULE_FILTER_TYPE.EXCLUDE]),
  enabled: _propTypes.default.bool.isRequired,
  filterListIds: _propTypes.default.array.isRequired,
  updateScope: _propTypes.default.func.isRequired
};