"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevertModelSnapshotFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _ml_api_service = require("../../../services/ml_api_service");
var _kibana = require("../../../contexts/kibana");
var _chart_loader = require("./chart_loader");
var _results_service = require("../../../services/results_service");
var _event_rate_chart = require("../../../jobs/new_job/pages/components/charts/event_rate_chart/event_rate_chart");
var _parse_interval = require("../../../../../common/util/parse_interval");
var _create_calendar = require("./create_calendar");
var _toast_notification_service = require("../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RevertModelSnapshotFlyout = ({
  snapshot,
  snapshots,
  job,
  closeFlyout,
  refresh
}) => {
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const {
    loadAnomalyDataForJob,
    loadEventRateForJob
  } = (0, _react.useMemo)(() => (0, _chart_loader.chartLoaderProvider)(_results_service.mlResultsService), []);
  const [currentSnapshot, setCurrentSnapshot] = (0, _react.useState)(snapshot);
  const [revertModalVisible, setRevertModalVisible] = (0, _react.useState)(false);
  const [replay, setReplay] = (0, _react.useState)(false);
  const [runInRealTime, setRunInRealTime] = (0, _react.useState)(false);
  const [createCalendar, setCreateCalendar] = (0, _react.useState)(false);
  const [calendarEvents, setCalendarEvents] = (0, _react.useState)([]);
  const [calendarEventsValid, setCalendarEventsValid] = (0, _react.useState)(true);
  const [eventRateData, setEventRateData] = (0, _react.useState)([]);
  const [anomalies, setAnomalies] = (0, _react.useState)([]);
  const [chartReady, setChartReady] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    createChartData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentSnapshot]);
  (0, _react.useEffect)(() => {
    const invalid = calendarEvents.some(c => c.description === '' || c.end === null || c.start === null);
    setCalendarEventsValid(invalid === false);

    // a bug in elastic charts selection can
    // cause duplicate selected areas to be added
    // dedupe the calendars based on start and end times
    const calMap = new Map(calendarEvents.map(c => {
      var _c$start, _c$end;
      return [`${(_c$start = c.start) === null || _c$start === void 0 ? void 0 : _c$start.valueOf()}${(_c$end = c.end) === null || _c$end === void 0 ? void 0 : _c$end.valueOf()}`, c];
    }));
    const dedupedCalendarEvents = [...calMap.values()];
    if (dedupedCalendarEvents.length < calendarEvents.length) {
      // deduped list is shorter, we must have removed something.
      setCalendarEvents(dedupedCalendarEvents);
    }
  }, [calendarEvents]);
  const createChartData = (0, _react.useCallback)(async () => {
    const bucketSpanMs = (0, _parse_interval.parseInterval)(job.analysis_config.bucket_span).asMilliseconds();
    const eventRate = await loadEventRateForJob(job, bucketSpanMs, 100);
    const anomalyData = await loadAnomalyDataForJob(job, bucketSpanMs, 100);
    setEventRateData(eventRate);
    if (anomalyData[0] !== undefined) {
      setAnomalies(anomalyData[0]);
    }
    setChartReady(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [job]);
  function showRevertModal() {
    setRevertModalVisible(true);
  }
  function hideRevertModal() {
    setRevertModalVisible(false);
  }
  async function applyRevert() {
    const end = replay && runInRealTime === false ? job.data_counts.latest_record_timestamp : undefined;
    try {
      const events = replay && createCalendar ? calendarEvents.filter(filterIncompleteEvents).map(c => ({
        start: c.start.valueOf(),
        end: c.end.valueOf(),
        description: c.description
      })) : undefined;
      _ml_api_service.ml.jobs.revertModelSnapshot(job.job_id, currentSnapshot.snapshot_id, replay, end, events).then(() => {
        toasts.addSuccess(_i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.revertSuccessTitle', {
          defaultMessage: 'Model snapshot revert successful'
        }));
        refresh();
      }).catch(error => {
        const {
          displayErrorToast
        } = (0, _toast_notification_service.toastNotificationServiceProvider)(toasts);
        displayErrorToast(error);
      });
      hideRevertModal();
      closeFlyout();
    } catch (error) {
      toasts.addError(new Error(error.body.message), {
        title: _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.revertErrorTitle', {
          defaultMessage: 'Model snapshot revert failed'
        })
      });
    }
  }
  function onSnapshotChange(ssId) {
    const ss = snapshots.find(s => s.snapshot_id === ssId);
    if (ss !== undefined) {
      setCurrentSnapshot(ss);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    hideCloseButton: true,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.title",
    defaultMessage: "Revert to model snapshot {ssId}",
    values: {
      ssId: currentSnapshot.snapshot_id
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, currentSnapshot.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, false &&
  /*#__PURE__*/
  // disabled for now
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.changeSnapshotLabel', {
      defaultMessage: 'Change snapshot'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: snapshots.map(s => ({
      value: s.snapshot_id,
      inputDisplay: s.snapshot_id,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, s.snapshot_id), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, s.description)))
    })).reverse(),
    valueOfSelected: currentSnapshot.snapshot_id,
    onChange: onSnapshotChange,
    itemLayoutAlign: "top",
    hasDividers: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateData,
    anomalyData: anomalies,
    loading: chartReady === false,
    height: '100px',
    width: '100%',
    fadeChart: true,
    overlayRanges: [{
      start: currentSnapshot.latest_record_time_stamp,
      end: job.data_counts.latest_record_timestamp,
      color: '#ff0000'
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.warningCallout.title', {
      defaultMessage: 'Anomaly data will be deleted'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.warningCallout.contents",
    defaultMessage: "All anomaly detection results after {date} will be deleted.",
    values: {
      date: (0, _mlDateUtils.timeFormatter)(currentSnapshot.latest_record_time_stamp)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.replaySwitchHelp', {
      defaultMessage: 'Reopen job and replay analysis after the revert has been applied.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "replaySwitch",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.replaySwitchLabel', {
      defaultMessage: 'Replay analysis'
    }),
    checked: replay,
    onChange: e => setReplay(e.target.checked)
  })), replay && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.realTimeSwitchHelp', {
      defaultMessage: 'Job will continue to run until manually stopped. All new data added to the index will be analyzed.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "realTimeSwitch",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.realTimeSwitchLabel', {
      defaultMessage: 'Run job in real time'
    }),
    checked: runInRealTime,
    onChange: e => setRunInRealTime(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.createCalendarSwitchHelp', {
      defaultMessage: 'Create a new calendar and event to skip over a period of time when analyzing the data.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "createCalendarSwitch",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.createCalendarSwitchLabel', {
      defaultMessage: 'Create calendar to skip a range of time'
    }),
    checked: createCalendar,
    onChange: e => setCreateCalendar(e.target.checked)
  })), createCalendar && /*#__PURE__*/_react.default.createElement(_create_calendar.CreateCalendar, {
    calendarEvents: calendarEvents,
    setCalendarEvents: setCalendarEvents,
    minSelectableTimeStamp: snapshot.latest_record_time_stamp,
    maxSelectableTimeStamp: job.data_counts.latest_record_timestamp,
    eventRateData: eventRateData,
    anomalies: anomalies,
    chartReady: chartReady
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: showRevertModal,
    disabled: createCalendar === true && calendarEventsValid === false,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.saveButton",
    defaultMessage: "Apply"
  })))))), revertModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.deleteTitle', {
      defaultMessage: 'Apply snapshot revert'
    }),
    onCancel: hideRevertModal,
    onConfirm: applyRevert,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.deleteButton', {
      defaultMessage: 'Apply'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.modalBody",
    defaultMessage: "The snapshot revert will be carried out in the background and may take some time."
  })));
};
exports.RevertModelSnapshotFlyout = RevertModelSnapshotFlyout;
function filterIncompleteEvents(event) {
  return event.start !== null && event.end !== null;
}