"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSteps = getSteps;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSteps(step, isConfigureStepValid, isPipelineDataValid) {
  let nextStep;
  let previousStep;
  let isContinueButtonEnabled = false;
  switch (step) {
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS:
      nextStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR;
      isContinueButtonEnabled = isConfigureStepValid;
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR:
      nextStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE;
      previousStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS;
      isContinueButtonEnabled = isPipelineDataValid;
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE:
      nextStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST;
      previousStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR;
      isContinueButtonEnabled = isPipelineDataValid;
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST:
      nextStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE;
      previousStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE;
      isContinueButtonEnabled = true;
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE:
      previousStep = _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST;
      isContinueButtonEnabled = true;
      break;
  }
  return {
    nextStep,
    previousStep,
    isContinueButtonEnabled
  };
}