"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexWithPipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _kibana = require("../../../contexts/kibana");
var _es_utils = require("../../../../../common/util/es_utils");
var _retry_create_data_view = require("../retry_create_data_view");
var _toast_notification_service = require("../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const destIndexEmpty = _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.destIndexEmpty', {
  defaultMessage: 'Enter a valid destination index'
});
const destIndexExists = _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.destIndexExists', {
  defaultMessage: 'An index with this name already exists.'
});
const destIndexInvalid = _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.destIndexInvalid', {
  defaultMessage: 'Index name cannot be empty. It must be lowercase. It cannot start with -, _, +. It cannot include \\\\, /, *, ?, ", <, >, |, space character, comma, #, :'
});
const ReindexWithPipeline = ({
  pipelineName,
  sourceIndex
}) => {
  var _capabilities$discove2;
  const [selectedIndex, setSelectedIndex] = (0, _react.useState)([{
    label: sourceIndex
  }]);
  const [options, setOptions] = (0, _react.useState)([]);
  const [destinationIndex, setDestinationIndex] = (0, _react.useState)('');
  const [destinationIndexExists, setDestinationIndexExists] = (0, _react.useState)(false);
  const [destinationIndexInvalidMessage, setDestinationIndexInvalidMessage] = (0, _react.useState)(destIndexEmpty);
  const [reindexingTaskId, setReindexingTaskId] = (0, _react.useState)();
  const [discoverLink, setDiscoverLink] = (0, _react.useState)();
  const [shouldCreateDataView, setShouldCreateDataView] = (0, _react.useState)(false);
  const [canReindex, setCanReindex] = (0, _react.useState)(false);
  const [canReindexError, setCanReindexError] = (0, _react.useState)();
  const {
    services: {
      application: {
        capabilities
      },
      share,
      data,
      mlServices: {
        mlApiServices: {
          getIndices,
          reindexWithPipeline,
          hasPrivileges
        }
      },
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const canCreateDataView = (0, _react.useMemo)(() => capabilities.savedObjectsManagement.edit === true || capabilities.indexPatterns.save === true, [capabilities]);
  const id = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const showDiscoverLink = (0, _react.useMemo)(() => {
    var _capabilities$discove;
    return ((_capabilities$discove = capabilities.discover) === null || _capabilities$discove === void 0 ? void 0 : _capabilities$discove.show) !== undefined && discoverLocator !== undefined;
  }, [(_capabilities$discove2 = capabilities.discover) === null || _capabilities$discove2 === void 0 ? void 0 : _capabilities$discove2.show, discoverLocator]);
  const generateDiscoverUrl = (0, _react.useCallback)(async dataViewId => {
    if (discoverLocator !== undefined) {
      const url = await discoverLocator.getRedirectUrl({
        indexPatternId: dataViewId,
        timeRange: data.query.timefilter.timefilter.getTime(),
        filters: data.query.filterManager.getFilters()
      });
      return url;
    }
  }, [discoverLocator, data]);
  const debouncedIndexCheck = (0, _lodash.debounce)(async () => {
    const checkResp = await (0, _retry_create_data_view.checkIndexExists)(destinationIndex);
    if (checkResp.errorMessage !== undefined) {
      displayErrorToast(checkResp.errorMessage, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.errorCheckingIndexExists', {
        defaultMessage: 'An error occurred getting the existing index names'
      }));
    } else if (checkResp.resp) {
      setDestinationIndexExists(checkResp.resp[destinationIndex].exists);
    }
  }, 400);
  const onReindex = async () => {
    try {
      const srcIndex = selectedIndex[0].label;
      const result = await reindexWithPipeline(pipelineName, srcIndex, destinationIndex);
      setReindexingTaskId(result.task);
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexErrorMessage', {
        defaultMessage: 'An error occurred reindexing'
      }));
    }
  };
  const onChange = selected => {
    setSelectedIndex(selected);
  };
  const onDestIndexNameChange = e => {
    setDestinationIndex(e.target.value);
    if (e.target.value === '') {
      setDestinationIndexInvalidMessage(destIndexEmpty);
    } else if (!(0, _es_utils.isValidIndexName)(e.target.value)) {
      setDestinationIndexInvalidMessage(destIndexInvalid);
    } else {
      setDestinationIndexInvalidMessage(undefined);
    }
  };
  (0, _react.useEffect)(function canReindexCheck() {
    async function checkPrivileges() {
      try {
        const privilege = await hasPrivileges({
          index: [{
            names: [selectedIndex[0].label],
            // uses wildcard
            privileges: ['read']
          }, {
            names: [destinationIndex],
            // uses wildcard
            privileges: ['write']
          }]
        });
        setCanReindex(privilege.hasPrivileges === undefined || privilege.hasPrivileges.has_all_requested === true);
      } catch (e) {
        const error = (0, _mlErrorUtils.extractErrorMessage)(e);
        const errorMessage = _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.indexPrivilegeErrorMessage', {
          defaultMessage: 'User does not have required permissions to reindex {index}. {error}',
          values: {
            error,
            index: selectedIndex[0].label
          }
        });
        setCanReindexError(errorMessage);
      }
    }
    if (hasPrivileges !== undefined) {
      checkPrivileges();
    }
  }, [hasPrivileges, sourceIndex, destinationIndex, selectedIndex]);
  (0, _react.useEffect)(function checkDestIndexExists() {
    if (destinationIndex !== undefined && destinationIndex !== '') {
      debouncedIndexCheck();
    }
  }, [destinationIndex, debouncedIndexCheck]);
  (0, _react.useEffect)(function getIndexOptions() {
    async function getAllIndices() {
      const indices = await getIndices();
      const indexOptions = indices.map(index => ({
        label: index.name
      }));
      setOptions(indexOptions);
    }
    getAllIndices();
  }, [getIndices]);
  (0, _react.useEffect)(function createDiscoverLink() {
    async function createDataView() {
      const dataViewCreationResult = await (0, _retry_create_data_view.createKibanaDataView)(destinationIndex, data.dataViews);
      if ((dataViewCreationResult === null || dataViewCreationResult === void 0 ? void 0 : dataViewCreationResult.success) === true && dataViewCreationResult !== null && dataViewCreationResult !== void 0 && dataViewCreationResult.dataViewId && showDiscoverLink) {
        const url = await generateDiscoverUrl(dataViewCreationResult.dataViewId);
        setDiscoverLink(url);
      }
    }
    if (reindexingTaskId !== undefined && shouldCreateDataView === true) {
      createDataView();
    }
  }, [reindexingTaskId, destinationIndex, data === null || data === void 0 ? void 0 : data.dataViews, generateDiscoverUrl, showDiscoverLink, shouldCreateDataView]);
  const reindexButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onReindex,
    disabled: destinationIndexInvalidMessage !== undefined && selectedIndex.length > 0 || !canReindex || destinationIndexExists,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexLabel",
    defaultMessage: "Reindex"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false
  }, reindexingTaskId === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexingTitle",
    defaultMessage: "Reindex with pipeline"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "GrayText"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: links.upgradeAssistant.reindexWithPipeline,
    target: "_blank",
    external: true
  }, 'Learn more.'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexingTooltip",
      defaultMessage: "Reindex data from the source index to a destination index using the new pipeline, which adds inference results to each document."
    }),
    position: "right"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.selectIndexLabel",
      defaultMessage: "Select index to reindex"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedIndex,
    onChange: onChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.destinationIndexLabel",
      defaultMessage: "Destination index name"
    }),
    isInvalid: destinationIndexInvalidMessage !== undefined || destinationIndexExists,
    error: destinationIndexInvalidMessage || destinationIndexExists ? destinationIndexInvalidMessage !== null && destinationIndexInvalidMessage !== void 0 ? destinationIndexInvalidMessage : destIndexExists : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: destinationIndex,
    onChange: onDestIndexNameChange,
    "aria-label": _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.destIndexFieldAriaLabel', {
      defaultMessage: 'Enter the name of the destination index'
    })
  }))), canCreateDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.createDataViewLabel', {
      defaultMessage: 'Create data view'
    }),
    checked: shouldCreateDataView,
    onChange: e => setShouldCreateDataView(e.target.checked)
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, canReindexError ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: canReindexError
  }, reindexButton) : reindexButton))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStepSuccessCallout",
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexStartedMessage', {
      defaultMessage: 'Reindexing of {sourceIndex} to {destinationIndex} has started.',
      values: {
        sourceIndex,
        destinationIndex
      }
    }),
    color: "success",
    iconType: "check"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexingTaskIdMessage",
    defaultMessage: "Reindexing task id {taskId} can be used to monitor the progress via the {tasksApi}.",
    values: {
      taskId: reindexingTaskId,
      tasksApi: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `${links.apis.tasks}`,
        target: "_blank",
        external: true
      }, 'task management API')
    }
  }), discoverLink !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.reindexedlinkToDiscover",
    defaultMessage: " View {destIndexInDiscover} in Discover.",
    values: {
      destIndexInDiscover: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `${discoverLink}`,
        target: "_blank",
        external: true
      }, destinationIndex)
    }
  }) : null)));
};
exports.ReindexWithPipeline = ReindexWithPipeline;