"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMessages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _component_utils = require("../../util/component_utils");
var _job_message_icon = require("../job_message_icon");
var _ml = require("../../contexts/ml");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component for rendering job messages for anomaly detection
 * and data frame analytics jobs.
 */
const JobMessages = ({
  messages,
  loading,
  error,
  refreshMessage,
  actionHandler
}) => {
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      name: refreshMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.ml.jobMessages.refreshLabel', {
          defaultMessage: 'Refresh'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: (0, _component_utils.blurButtonOnClick)(() => {
          refreshMessage();
        }),
        iconType: "refresh",
        "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.refreshAriaLabel', {
          defaultMessage: 'Refresh'
        })
      })) : '',
      render: message => /*#__PURE__*/_react.default.createElement(_job_message_icon.JobIcon, {
        message: message
      }),
      width: `${_uiTheme.euiLightVars.euiSizeL}`
    }, {
      field: 'timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobMessages.timeLabel', {
        defaultMessage: 'Time'
      }),
      render: _mlDateUtils.timeFormatter,
      width: '120px',
      sortable: true
    }, {
      field: 'message',
      name: _i18n.i18n.translate('xpack.ml.jobMessages.messageLabel', {
        defaultMessage: 'Message'
      }),
      width: '50%'
    }];
    if (showNodeInfo) {
      cols.splice(2, 0, {
        field: 'node_name',
        name: _i18n.i18n.translate('xpack.ml.jobMessages.nodeLabel', {
          defaultMessage: 'Node'
        }),
        width: '150px'
      });
    }
    if (typeof actionHandler === 'function') {
      cols.push({
        name: _i18n.i18n.translate('xpack.ml.jobMessages.actionsLabel', {
          defaultMessage: 'Actions'
        }),
        width: '10%',
        actions: [{
          render: message => {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
              content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.jobMessages.toggleInChartTooltipText",
                defaultMessage: "Toggle in chart"
              })
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
              size: "xs",
              "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.toggleInChartAriaLabel', {
                defaultMessage: 'Toggle in chart'
              }),
              iconType: "visAreaStacked",
              onClick: () => actionHandler(message)
            }));
          }
        }]
      });
    }
    return cols;
  }, [showNodeInfo, refreshMessage, actionHandler]);
  const defaultSorting = {
    sort: {
      field: 'timestamp',
      direction: 'desc'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: messages,
    columns: columns,
    sorting: defaultSorting,
    compressed: true,
    loading: loading,
    error: error,
    pagination: true,
    "data-test-subj": 'mlAnalyticsDetailsJobMessagesTable'
  }));
};
exports.JobMessages = JobMessages;