"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderMenuPortal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana = require("../../contexts/kibana");
var _ml_page = require("../ml_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderMenuPortal = ({
  children
}) => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    theme,
    i18n
  } = services;
  const {
    setHeaderActionMenu
  } = (0, _react.useContext)(_ml_page.MlPageControlsContext);
  const portalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  (0, _react.useEffect)(() => {
    if (!setHeaderActionMenu) {
      return;
    }
    setHeaderActionMenu(element => {
      const mount = (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: services
      }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: portalNode
      })), {
        theme,
        i18n
      });
      return mount(element);
    });
    return () => {
      portalNode.unmount();
      setHeaderActionMenu(undefined);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [portalNode, setHeaderActionMenu, services.theme.theme$]);
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: portalNode
  }, children);
};
exports.HeaderMenuPortal = HeaderMenuPortal;