"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMergedSampleDocsForPopulatedFieldsQuery = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _lodash = require("lodash");
var _mlQueryUtils = require("@kbn/ml-query-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMergedSampleDocsForPopulatedFieldsQuery = ({
  runtimeFields,
  searchQuery,
  datetimeField,
  timeRange
}) => {
  let rangeFilter;
  if (timeRange && datetimeField !== undefined) {
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(timeRange, ['from', 'to']) && timeRange.to > timeRange.from) {
      rangeFilter = {
        range: {
          [datetimeField]: {
            gte: timeRange.from,
            lte: timeRange.to,
            format: 'epoch_millis'
          }
        }
      };
    }
  }
  const query = (0, _lodash.cloneDeep)(!searchQuery || (0, _mlIsPopulatedObject.isPopulatedObject)(searchQuery, ['match_all']) ? (0, _mlQueryUtils.getDefaultDSLQuery)() : searchQuery);
  if (rangeFilter && (0, _mlIsPopulatedObject.isPopulatedObject)(query, ['bool'])) {
    if (Array.isArray(query.bool.filter)) {
      query.bool.filter.push(rangeFilter);
    } else {
      query.bool.filter = [rangeFilter];
    }
  }
  const queryAndRuntimeFields = {
    query: {
      function_score: {
        query,
        // @ts-expect-error random_score is valid dsl query
        random_score: {}
      }
    }
  };
  if (runtimeFields) {
    queryAndRuntimeFields.runtime_mappings = runtimeFields;
  }
  return queryAndRuntimeFields;
};
exports.getMergedSampleDocsForPopulatedFieldsQuery = getMergedSampleDocsForPopulatedFieldsQuery;