"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertFlyout = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHeader = ({
  alert
}) => {
  const name = alert[_ruleDataUtils.ALERT_RULE_NAME];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, name));
};
const getAlertFlyout = (columns, formatter) => () => {
  const FlyoutBody = ({
    alert,
    id
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: columns.map(column => {
      var _get;
      const value = (_get = (0, _lodash.get)(alert, column.id)) === null || _get === void 0 ? void 0 : _get[0];
      return {
        title: column.displayAsText,
        description: (0, _mlIsDefined.isDefined)(value) ? formatter(column.id, value) : '—'
      };
    }),
    type: "column",
    columnWidths: [1, 3] // Same as [25, 75]
  }));

  return {
    body: FlyoutBody,
    header: FlyoutHeader,
    footer: null
  };
};
exports.getAlertFlyout = getAlertFlyout;