"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALID_TOKEN_COUNT = exports.VALIDATION_RESULT = exports.VALIDATION_CHECK_DESCRIPTION = exports.NULL_COUNT_PERCENT_LIMIT = exports.MEDIAN_LINE_LENGTH_LIMIT = exports.CATEGORY_EXAMPLES_WARNING_LIMIT = exports.CATEGORY_EXAMPLES_VALIDATION_STATUS = exports.CATEGORY_EXAMPLES_SAMPLE_SIZE = exports.CATEGORY_EXAMPLES_ERROR_LIMIT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The number of category examples to use for analysis.
 */
const CATEGORY_EXAMPLES_SAMPLE_SIZE = 1000;

/**
 * The warning limit for category examples. If the category examples validation falls below this limit, a warning is triggered.
 */
exports.CATEGORY_EXAMPLES_SAMPLE_SIZE = CATEGORY_EXAMPLES_SAMPLE_SIZE;
const CATEGORY_EXAMPLES_WARNING_LIMIT = 0.75;

/**
 * The error limit for category examples. If the category examples validation falls below this limit, an error is triggered.
 */
exports.CATEGORY_EXAMPLES_WARNING_LIMIT = CATEGORY_EXAMPLES_WARNING_LIMIT;
const CATEGORY_EXAMPLES_ERROR_LIMIT = 0.02;

/**
 * The valid token count for category examples.
 */
exports.CATEGORY_EXAMPLES_ERROR_LIMIT = CATEGORY_EXAMPLES_ERROR_LIMIT;
const VALID_TOKEN_COUNT = 3;

/**
 * The limit for the median line length of category examples.
 */
exports.VALID_TOKEN_COUNT = VALID_TOKEN_COUNT;
const MEDIAN_LINE_LENGTH_LIMIT = 400;

/**
 * The limit for the percentage of null values in category examples.
 */
exports.MEDIAN_LINE_LENGTH_LIMIT = MEDIAN_LINE_LENGTH_LIMIT;
const NULL_COUNT_PERCENT_LIMIT = 0.75;

/**
 * Enum representing the validation status of category examples.
 */
exports.NULL_COUNT_PERCENT_LIMIT = NULL_COUNT_PERCENT_LIMIT;
let CATEGORY_EXAMPLES_VALIDATION_STATUS;
/**
 * Enum representing the validation results for field examples.
 */
exports.CATEGORY_EXAMPLES_VALIDATION_STATUS = CATEGORY_EXAMPLES_VALIDATION_STATUS;
(function (CATEGORY_EXAMPLES_VALIDATION_STATUS) {
  CATEGORY_EXAMPLES_VALIDATION_STATUS["VALID"] = "valid";
  CATEGORY_EXAMPLES_VALIDATION_STATUS["PARTIALLY_VALID"] = "partially_valid";
  CATEGORY_EXAMPLES_VALIDATION_STATUS["INVALID"] = "invalid";
})(CATEGORY_EXAMPLES_VALIDATION_STATUS || (exports.CATEGORY_EXAMPLES_VALIDATION_STATUS = CATEGORY_EXAMPLES_VALIDATION_STATUS = {}));
let VALIDATION_RESULT;
/**
 * Description for each validation result.
 */
exports.VALIDATION_RESULT = VALIDATION_RESULT;
(function (VALIDATION_RESULT) {
  VALIDATION_RESULT[VALIDATION_RESULT["NO_EXAMPLES"] = 0] = "NO_EXAMPLES";
  VALIDATION_RESULT[VALIDATION_RESULT["FAILED_TO_TOKENIZE"] = 1] = "FAILED_TO_TOKENIZE";
  VALIDATION_RESULT[VALIDATION_RESULT["TOO_MANY_TOKENS"] = 2] = "TOO_MANY_TOKENS";
  VALIDATION_RESULT[VALIDATION_RESULT["TOKEN_COUNT"] = 3] = "TOKEN_COUNT";
  VALIDATION_RESULT[VALIDATION_RESULT["MEDIAN_LINE_LENGTH"] = 4] = "MEDIAN_LINE_LENGTH";
  VALIDATION_RESULT[VALIDATION_RESULT["NULL_VALUES"] = 5] = "NULL_VALUES";
  VALIDATION_RESULT[VALIDATION_RESULT["INSUFFICIENT_PRIVILEGES"] = 6] = "INSUFFICIENT_PRIVILEGES";
})(VALIDATION_RESULT || (exports.VALIDATION_RESULT = VALIDATION_RESULT = {}));
const VALIDATION_CHECK_DESCRIPTION = {
  /**
   * Examples were successfully loaded.
   */
  [VALIDATION_RESULT.NO_EXAMPLES]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validNoDataFound', {
    defaultMessage: 'Examples were successfully loaded.'
  }),
  /**
   * The loaded examples were tokenized successfully.
   */
  [VALIDATION_RESULT.FAILED_TO_TOKENIZE]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validFailureToGetTokens', {
    defaultMessage: 'The loaded examples were tokenized successfully.'
  }),
  /**
   * More than {tokenCount} tokens per example were found in over {percentage}% of the loaded examples.
   */
  [VALIDATION_RESULT.TOKEN_COUNT]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validTokenLength', {
    defaultMessage: 'More than {tokenCount} tokens per example were found in over {percentage}% of the loaded examples.',
    values: {
      percentage: Math.floor(CATEGORY_EXAMPLES_WARNING_LIMIT * 100),
      tokenCount: VALID_TOKEN_COUNT
    }
  }),
  /**
   * The median line length of the loaded examples was less than {medianCharCount} characters.
   */
  [VALIDATION_RESULT.MEDIAN_LINE_LENGTH]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validMedianLineLength', {
    defaultMessage: 'The median line length of the loaded examples was less than {medianCharCount} characters.',
    values: {
      medianCharCount: MEDIAN_LINE_LENGTH_LIMIT
    }
  }),
  /**
   * Less than {percentage}% of the loaded examples were null.
   */
  [VALIDATION_RESULT.NULL_VALUES]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validNullValues', {
    defaultMessage: 'Less than {percentage}% of the loaded examples were null.',
    values: {
      percentage: Math.floor(100 - NULL_COUNT_PERCENT_LIMIT * 100)
    }
  }),
  /**
   * Less than 10000 tokens were found in total in the loaded examples.
   */
  [VALIDATION_RESULT.TOO_MANY_TOKENS]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validTooManyTokens', {
    defaultMessage: 'Less than 10000 tokens were found in total in the loaded examples.'
  }),
  /**
   * The user has sufficient privileges to perform the checks.
   */
  [VALIDATION_RESULT.INSUFFICIENT_PRIVILEGES]: _i18n.i18n.translate('xpack.ml.models.jobService.categorization.messages.validUserPrivileges', {
    defaultMessage: 'The user has sufficient privileges to perform the checks.'
  })
};
exports.VALIDATION_CHECK_DESCRIPTION = VALIDATION_CHECK_DESCRIPTION;