"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_DETECTOR_RULE_OPERATOR = exports.ML_DETECTOR_RULE_FILTER_TYPE = exports.ML_DETECTOR_RULE_CONDITIONS_NOT_SUPPORTED_FUNCTIONS = exports.ML_DETECTOR_RULE_APPLIES_TO = exports.ML_DETECTOR_RULE_ACTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Contains values for ML job detector rules.
 */
/**
 * Enum ML_DETECTOR_RULE_ACTION
 */
let ML_DETECTOR_RULE_ACTION;
/**
 * Enum ML_DETECTOR_RULE_FILTER_TYPE
 */
exports.ML_DETECTOR_RULE_ACTION = ML_DETECTOR_RULE_ACTION;
(function (ML_DETECTOR_RULE_ACTION) {
  ML_DETECTOR_RULE_ACTION["SKIP_MODEL_UPDATE"] = "skip_model_update";
  ML_DETECTOR_RULE_ACTION["SKIP_RESULT"] = "skip_result";
})(ML_DETECTOR_RULE_ACTION || (exports.ML_DETECTOR_RULE_ACTION = ML_DETECTOR_RULE_ACTION = {}));
let ML_DETECTOR_RULE_FILTER_TYPE;
/**
 * Enum ML_DETECTOR_RULE_APPLIES_TO
 */
exports.ML_DETECTOR_RULE_FILTER_TYPE = ML_DETECTOR_RULE_FILTER_TYPE;
(function (ML_DETECTOR_RULE_FILTER_TYPE) {
  ML_DETECTOR_RULE_FILTER_TYPE["EXCLUDE"] = "exclude";
  ML_DETECTOR_RULE_FILTER_TYPE["INCLUDE"] = "include";
})(ML_DETECTOR_RULE_FILTER_TYPE || (exports.ML_DETECTOR_RULE_FILTER_TYPE = ML_DETECTOR_RULE_FILTER_TYPE = {}));
let ML_DETECTOR_RULE_APPLIES_TO;
/**
 * Enum ML_DETECTOR_RULE_OPERATOR
 */
exports.ML_DETECTOR_RULE_APPLIES_TO = ML_DETECTOR_RULE_APPLIES_TO;
(function (ML_DETECTOR_RULE_APPLIES_TO) {
  ML_DETECTOR_RULE_APPLIES_TO["ACTUAL"] = "actual";
  ML_DETECTOR_RULE_APPLIES_TO["DIFF_FROM_TYPICAL"] = "diff_from_typical";
  ML_DETECTOR_RULE_APPLIES_TO["TYPICAL"] = "typical";
})(ML_DETECTOR_RULE_APPLIES_TO || (exports.ML_DETECTOR_RULE_APPLIES_TO = ML_DETECTOR_RULE_APPLIES_TO = {}));
let ML_DETECTOR_RULE_OPERATOR;
/**
 * List of detector functions which don't support rules with numeric conditions.
 */
exports.ML_DETECTOR_RULE_OPERATOR = ML_DETECTOR_RULE_OPERATOR;
(function (ML_DETECTOR_RULE_OPERATOR) {
  ML_DETECTOR_RULE_OPERATOR["LESS_THAN"] = "lt";
  ML_DETECTOR_RULE_OPERATOR["LESS_THAN_OR_EQUAL"] = "lte";
  ML_DETECTOR_RULE_OPERATOR["GREATER_THAN"] = "gt";
  ML_DETECTOR_RULE_OPERATOR["GREATER_THAN_OR_EQUAL"] = "gte";
})(ML_DETECTOR_RULE_OPERATOR || (exports.ML_DETECTOR_RULE_OPERATOR = ML_DETECTOR_RULE_OPERATOR = {}));
const ML_DETECTOR_RULE_CONDITIONS_NOT_SUPPORTED_FUNCTIONS = ['freq_rare', 'lat_long', 'metric', 'rare'];
exports.ML_DETECTOR_RULE_CONDITIONS_NOT_SUPPORTED_FUNCTIONS = ML_DETECTOR_RULE_CONDITIONS_NOT_SUPPORTED_FUNCTIONS;