"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsDataSourceSavedObjectType = exports.metricsDataSourceSavedObjectName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsDataSourceSavedObjectName = 'metrics-data-source';
exports.metricsDataSourceSavedObjectName = metricsDataSourceSavedObjectName;
const metricsDataSourceSavedObjectType = {
  name: metricsDataSourceSavedObjectName,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'name',
    displayName: 'metrics data source',
    getTitle(savedObject) {
      return `Metrics data source [id=${savedObject.id}]`;
    },
    icon: 'metricsApp',
    importableAndExportable: true
  },
  mappings: {
    dynamic: false,
    properties: {}
  }
};
exports.metricsDataSourceSavedObjectType = metricsDataSourceSavedObjectType;