"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snapshot = void 0;
var _cpu = require("./cpu");
var _disk_latency = require("./disk_latency");
var _disk_space_usage = require("./disk_space_usage");
var _count = require("../../../shared/metrics/snapshot/count");
var _load = require("./load");
var _log_rate = require("./log_rate");
var _memory = require("./memory");
var _memory_free = require("./memory_free");
var _memory_total = require("./memory_total");
var _normalized_load_1m = require("./normalized_load_1m");
var _rx = require("./rx");
var _tx = require("./tx");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const snapshot = {
  cpu: _cpu.cpu,
  diskLatency: _disk_latency.diskLatency,
  diskSpaceUsage: _disk_space_usage.diskSpaceUsage,
  count: _count.count,
  load: _load.load,
  logRate: _log_rate.logRate,
  memory: _memory.memory,
  memoryFree: _memory_free.memoryFree,
  memoryTotal: _memory_total.memoryTotal,
  normalizedLoad1m: _normalized_load_1m.normalizedLoad1m,
  rx: _rx.rx,
  tx: _tx.tx
};
exports.snapshot = snapshot;