"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskReadThroughput = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskReadThroughput = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.diskReadThroughput', {
    defaultMessage: 'Disk Read Throughput'
  }),
  value: "counter_rate(max(system.diskio.read.bytes), kql='system.diskio.read.bytes: *')",
  format: {
    id: 'bytes',
    params: {
      decimals: 1
    }
  },
  timeScale: 's'
};
exports.diskReadThroughput = diskReadThroughput;