"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.memoryUsageBreakdown = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const memoryUsageBreakdown = {
  get: ({
    dataView
  }) => ({
    id: 'memoryUsageBreakdown',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.memoryUsage', {
      defaultMessage: 'Memory Usage'
    }),
    layers: [{
      data: [{
        ..._formulas.formulas.memoryCache,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.cache', {
          defaultMessage: 'Cache'
        })
      }, {
        ..._formulas.formulas.memoryUsed,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.used', {
          defaultMessage: 'Used'
        })
      }, {
        ..._formulas.formulas.memoryFreeExcludingCache,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.free', {
          defaultMessage: 'Free'
        })
      }],
      options: {
        seriesType: 'area_stacked'
      },
      layerType: 'data'
    }],
    visualOptions: {
      legend: {
        isVisible: true,
        position: 'bottom',
        legendSize: 50
      },
      yLeftExtent: {
        mode: 'dataBounds',
        lowerBound: 0,
        upperBound: 1
      }
    },
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.memoryUsageBreakdown = memoryUsageBreakdown;