"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskUsageByMountPoint = exports.diskThroughputReadWrite = exports.diskSpaceUsageAvailable = exports.diskIOReadWrite = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOP_VALUES_SIZE = 5;
const diskSpaceUsageAvailable = {
  get: ({
    dataView
  }) => ({
    id: 'diskSpaceUsageAvailable',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsage', {
      defaultMessage: 'Disk Usage'
    }),
    layers: [{
      data: [{
        ..._formulas.formulas.diskUsage,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsage.label.used', {
          defaultMessage: 'Used'
        })
      }, {
        ..._formulas.formulas.diskSpaceAvailability,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsage.label.available', {
          defaultMessage: 'Available'
        })
      }],
      options: {
        seriesType: 'area'
      },
      layerType: 'data'
    }],
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.diskSpaceUsageAvailable = diskSpaceUsageAvailable;
const diskUsageByMountPoint = {
  get: ({
    dataView
  }) => ({
    id: 'DiskUsageByMountPoint',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsageByMountingPoint', {
      defaultMessage: 'Disk Usage by Mount Point'
    }),
    layers: [{
      data: [{
        ..._formulas.formulas.diskUsage,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsage.label.used', {
          defaultMessage: 'Used'
        })
      }],
      options: {
        seriesType: 'area',
        breakdown: {
          type: 'top_values',
          field: 'system.filesystem.mount_point',
          params: {
            size: TOP_VALUES_SIZE
          }
        }
      },
      layerType: 'data'
    }],
    visualOptions: {
      legend: {
        isVisible: true,
        position: 'bottom',
        legendSize: 50
      },
      yLeftExtent: {
        mode: 'dataBounds',
        lowerBound: 0,
        upperBound: 1
      }
    },
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.diskUsageByMountPoint = diskUsageByMountPoint;
const diskThroughputReadWrite = {
  get: ({
    dataView
  }) => ({
    id: 'diskThroughputReadWrite',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskIOPS', {
      defaultMessage: 'Disk IOPS'
    }),
    layers: [{
      data: [{
        ..._formulas.formulas.diskIORead,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
          defaultMessage: 'Read'
        })
      }, {
        ..._formulas.formulas.diskIOWrite,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
          defaultMessage: 'Write'
        })
      }],
      options: {
        seriesType: 'area'
      },
      layerType: 'data'
    }],
    visualOptions: {
      yLeftExtent: {
        mode: 'dataBounds',
        lowerBound: 0,
        upperBound: 1
      }
    },
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.diskThroughputReadWrite = diskThroughputReadWrite;
const diskIOReadWrite = {
  get: ({
    dataView
  }) => ({
    id: 'diskIOReadWrite',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskThroughput', {
      defaultMessage: 'Disk Throughput'
    }),
    layers: [{
      data: [{
        ..._formulas.formulas.diskReadThroughput,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
          defaultMessage: 'Read'
        })
      }, {
        ..._formulas.formulas.diskWriteThroughput,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
          defaultMessage: 'Write'
        })
      }],
      options: {
        seriesType: 'area'
      },
      layerType: 'data'
    }],
    visualOptions: {
      yLeftExtent: {
        mode: 'dataBounds',
        lowerBound: 0,
        upperBound: 1
      }
    },
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.diskIOReadWrite = diskIOReadWrite;