"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _empty_prompt = require("./empty_prompt");
var _tile_request_tab = require("./tile_request_tab");
var _requests_view_callout = require("./requests_view_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class VectorTileInspector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      selectedLayer: null,
      selectedTileRequest: null,
      tileRequests: [],
      layerOptions: []
    });
    (0, _defineProperty2.default)(this, "_onAdapterChange", () => {
      const layerOptions = this.props.adapters.vectorTiles.getLayerOptions();
      if (layerOptions.length === 0) {
        this.setState({
          selectedLayer: null,
          selectedTileRequest: null,
          tileRequests: [],
          layerOptions: []
        });
        return;
      }
      const selectedLayer = this.state.selectedLayer && layerOptions.some(layerOption => {
        var _this$state$selectedL;
        return ((_this$state$selectedL = this.state.selectedLayer) === null || _this$state$selectedL === void 0 ? void 0 : _this$state$selectedL.value) === layerOption.value;
      }) ? this.state.selectedLayer : layerOptions[0];
      const tileRequests = this.props.adapters.vectorTiles.getTileRequests(selectedLayer.value);
      const selectedTileRequest = this.state.selectedTileRequest && tileRequests.some(tileRequest => {
        var _this$state$selectedT, _this$state$selectedT2, _this$state$selectedT3, _this$state$selectedT4;
        return ((_this$state$selectedT = this.state.selectedTileRequest) === null || _this$state$selectedT === void 0 ? void 0 : _this$state$selectedT.layerId) === tileRequest.layerId && ((_this$state$selectedT2 = this.state.selectedTileRequest) === null || _this$state$selectedT2 === void 0 ? void 0 : _this$state$selectedT2.x) === tileRequest.x && ((_this$state$selectedT3 = this.state.selectedTileRequest) === null || _this$state$selectedT3 === void 0 ? void 0 : _this$state$selectedT3.y) === tileRequest.y && ((_this$state$selectedT4 = this.state.selectedTileRequest) === null || _this$state$selectedT4 === void 0 ? void 0 : _this$state$selectedT4.z) === tileRequest.z;
      }) ? this.state.selectedTileRequest : tileRequests.length ? tileRequests[0] : null;
      this.setState({
        selectedLayer,
        selectedTileRequest,
        tileRequests,
        layerOptions
      });
    });
    (0, _defineProperty2.default)(this, "_debouncedOnAdapterChange", _lodash.default.debounce(() => {
      if (this._isMounted) {
        this._onAdapterChange();
      }
    }, 256));
    (0, _defineProperty2.default)(this, "_onLayerSelect", selectedOptions => {
      if (selectedOptions.length === 0) {
        this.setState({
          selectedLayer: null,
          selectedTileRequest: null,
          tileRequests: []
        });
        return;
      }
      const selectedLayer = selectedOptions[0];
      const tileRequests = this.props.adapters.vectorTiles.getTileRequests(selectedLayer.value);
      this.setState({
        selectedLayer,
        selectedTileRequest: tileRequests.length ? tileRequests[0] : null,
        tileRequests
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._onAdapterChange();
    this.props.adapters.vectorTiles.on('change', this._debouncedOnAdapterChange);
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.adapters.vectorTiles.removeListener('change', this._debouncedOnAdapterChange);
  }
  renderTabs() {
    return this.state.tileRequests.map(tileRequest => {
      var _this$state$selectedT5, _this$state$selectedT6, _this$state$selectedT7, _this$state$selectedT8;
      const tileLabel = `${tileRequest.z}/${tileRequest.x}/${tileRequest.y}`;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        key: `${tileRequest.layerId}${tileLabel}`,
        onClick: () => {
          this.setState({
            selectedTileRequest: tileRequest
          });
        },
        isSelected: tileRequest.layerId === ((_this$state$selectedT5 = this.state.selectedTileRequest) === null || _this$state$selectedT5 === void 0 ? void 0 : _this$state$selectedT5.layerId) && tileRequest.x === ((_this$state$selectedT6 = this.state.selectedTileRequest) === null || _this$state$selectedT6 === void 0 ? void 0 : _this$state$selectedT6.x) && tileRequest.y === ((_this$state$selectedT7 = this.state.selectedTileRequest) === null || _this$state$selectedT7 === void 0 ? void 0 : _this$state$selectedT7.y) && tileRequest.z === ((_this$state$selectedT8 = this.state.selectedTileRequest) === null || _this$state$selectedT8 === void 0 ? void 0 : _this$state$selectedT8.z)
      }, tileLabel);
    });
  }
  render() {
    return this.state.layerOptions.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_requests_view_callout.RequestsViewCallout, null), /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_requests_view_callout.RequestsViewCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      singleSelection: true,
      options: this.state.layerOptions,
      selectedOptions: this.state.selectedLayer ? [this.state.selectedLayer] : [],
      onChange: this._onLayerSelect,
      isClearable: false,
      prepend: _i18n.i18n.translate('xpack.maps.inspector.vectorTile.layerSelectPrepend', {
        defaultMessage: 'Layer'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s"
    }, this.renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), this.state.selectedTileRequest && /*#__PURE__*/_react.default.createElement(_tile_request_tab.TileRequestTab, {
      key: `${this.state.selectedTileRequest.layerId}${this.state.selectedTileRequest.x}${this.state.selectedTileRequest.y}${this.state.selectedTileRequest.z}`,
      tileRequest: this.state.selectedTileRequest
    }));
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
var _default = VectorTileInspector;
exports.default = _default;
module.exports = exports.default;