"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _operators = require("rxjs/operators");
var _uuid = require("uuid");
var _map_embeddable = require("./map_embeddable");
var _create_basemap_layer_descriptor = require("../classes/layers/create_basemap_layer_descriptor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MapComponent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_mapEmbeddable", void 0);
    (0, _defineProperty2.default)(this, "_embeddableRef", /*#__PURE__*/_react.default.createRef());
    this._mapEmbeddable = new _map_embeddable.MapEmbeddable({
      editable: false
    }, {
      id: (0, _uuid.v4)(),
      attributes: {
        title: this.props.title,
        layerListJSON: JSON.stringify([(0, _create_basemap_layer_descriptor.createBasemapLayerDescriptor)(), ...this.props.getLayerDescriptors()])
      },
      mapCenter: this.props.mapCenter
    });
    if (this.props.onInitialRenderComplete) {
      this._mapEmbeddable.getOnRenderComplete$().pipe((0, _operators.first)()).subscribe(() => {
        if (this.props.onInitialRenderComplete) {
          this.props.onInitialRenderComplete();
        }
      });
    }
    if (this.props.isSharable !== undefined) {
      this._mapEmbeddable.setIsSharable(this.props.isSharable);
    }
  }
  componentDidMount() {
    if (this._embeddableRef.current) {
      this._mapEmbeddable.render(this._embeddableRef.current);
    }
  }
  componentWillUnmount() {
    this._mapEmbeddable.destroy();
  }
  componentDidUpdate() {
    this._mapEmbeddable.updateInput({
      filters: this.props.filters,
      query: this.props.query,
      timeRange: this.props.timeRange
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapEmbeddableContainer",
      ref: this._embeddableRef
    });
  }
}
exports.MapComponent = MapComponent;