"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimesliderToggleButton = void 0;
var _reactRedux = require("react-redux");
var _timeslider_toggle_button = require("./timeslider_toggle_button");
var _actions = require("../../../actions");
var _ui_selectors = require("../../../selectors/ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isTimesliderOpen: (0, _ui_selectors.getIsTimesliderOpen)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    closeTimeslider: () => {
      dispatch((0, _actions.closeTimeslider)());
    },
    openTimeslider: () => {
      dispatch((0, _actions.openTimeslider)());
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_timeslider_toggle_button.TimesliderToggleButton);
exports.TimesliderToggleButton = connected;