"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerControl = void 0;
var _reactRedux = require("react-redux");
var _layer_control = require("./layer_control");
var _ui = require("../../../reducers/ui");
var _actions = require("../../../actions");
var _ui_selectors = require("../../../selectors/ui_selectors");
var _map_selectors = require("../../../selectors/map_selectors");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isReadOnly: (0, _ui_selectors.getIsReadOnly)(state),
    isLayerTOCOpen: (0, _ui_selectors.getIsLayerTOCOpen)(state),
    layerList: (0, _map_selectors.getLayerList)(state),
    isFlyoutOpen: (0, _ui_selectors.getFlyoutDisplay)(state) !== _ui.FLYOUT_STATE.NONE,
    zoom: (0, _map_selectors.getMapZoom)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    showAddLayerWizard: async () => {
      await dispatch((0, _actions.setSelectedLayer)(null));
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.ADD_LAYER_WIZARD));
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.NONE));
    },
    closeLayerTOC: () => {
      dispatch((0, _actions.setIsLayerTOCOpen)(false));
    },
    openLayerTOC: () => {
      dispatch((0, _actions.setIsLayerTOCOpen)(true));
    },
    hideAllLayers: () => {
      dispatch((0, _actions.hideAllLayers)());
    },
    showAllLayers: () => {
      dispatch((0, _actions.showAllLayers)());
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_layer_control.LayerControl);
exports.LayerControl = connected;