"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataRequestAbortError = exports.DataRequest = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class DataRequest {
  constructor(descriptor) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = {
      ...descriptor
    };
  }
  getData() {
    return this._descriptor.data;
  }
  isLoading() {
    return !!this._descriptor.dataRequestToken;
  }
  getMeta() {
    if (this._descriptor.dataRequestMetaAtStart) {
      return this._descriptor.dataRequestMetaAtStart;
    } else if (this._descriptor.dataRequestMeta) {
      return this._descriptor.dataRequestMeta;
    } else {
      return {};
    }
  }
  hasData() {
    return !!this._descriptor.data;
  }
  hasDataOrRequestInProgress() {
    return this.hasData() || this.isLoading();
  }
  getDataId() {
    return this._descriptor.dataId;
  }
  getRequestToken() {
    return this._descriptor.dataRequestToken;
  }
  renderError() {
    if (!this._descriptor.error) {
      return null;
    }
    const overrideDisplay = (0, _public.getSearchErrorOverrideDisplay)({
      error: this._descriptor.error,
      application: (0, _kibana_services.getApplication)()
    });
    const body = overrideDisplay !== null && overrideDisplay !== void 0 && overrideDisplay.body ? overrideDisplay.body : /*#__PURE__*/_react.default.createElement("p", null, this._descriptor.error.message);
    return overrideDisplay !== null && overrideDisplay !== void 0 && overrideDisplay.actions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, body, overrideDisplay.actions) : body;
  }
}
exports.DataRequest = DataRequest;
class DataRequestAbortError extends Error {
  constructor() {
    super();
  }
}
exports.DataRequestAbortError = DataRequestAbortError;