"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentilesForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _row_action_buttons = require("../row_action_buttons");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isInvalidPercentile(percentile) {
  if (typeof percentile !== 'number') {
    return true;
  }
  return percentile <= 0 || percentile >= 100;
}
class PercentilesForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      const hasInvalidPercentile = this.state.percentiles.some(isInvalidPercentile);
      if (!hasInvalidPercentile) {
        this.props.onChange(this.state.percentiles);
      }
    });
    this.state = {
      percentiles: props.initialPercentiles
    };
  }
  render() {
    const rows = this.state.percentiles.map((percentile, index) => {
      const onAdd = () => {
        let newPercentile = '';
        if (typeof percentile === 'number') {
          let delta = 1;
          if (index === this.state.percentiles.length - 1) {
            // Adding row to end of list.
            if (index !== 0) {
              const prevPercentile = this.state.percentiles[index - 1];
              if (typeof prevPercentile === 'number') {
                delta = percentile - prevPercentile;
              }
            }
          } else {
            // Adding row in middle of list.
            const nextPercentile = this.state.percentiles[index + 1];
            if (typeof nextPercentile === 'number') {
              delta = (nextPercentile - percentile) / 2;
            }
          }
          newPercentile = percentile + delta;
          if (newPercentile >= 100) {
            newPercentile = 99;
          }
        }
        const percentiles = [...this.state.percentiles.slice(0, index + 1), newPercentile, ...this.state.percentiles.slice(index + 1)];
        this.setState({
          percentiles
        }, this._onSubmit);
      };
      const onRemove = () => {
        const percentiles = this.state.percentiles.length === 1 ? this.state.percentiles : [...this.state.percentiles.slice(0, index), ...this.state.percentiles.slice(index + 1)];
        this.setState({
          percentiles
        }, this._onSubmit);
      };
      const onPercentileChange = event => {
        const sanitizedValue = parseFloat(event.target.value);
        const percentiles = [...this.state.percentiles];
        percentiles[index] = isNaN(sanitizedValue) ? '' : sanitizedValue;
        this.setState({
          percentiles
        }, this._onSubmit);
      };
      const isInvalid = isInvalidPercentile(percentile);
      const error = isInvalid ? _i18n.i18n.translate('xpack.maps.styles.invalidPercentileMsg', {
        defaultMessage: `Percentile must be a number between 0 and 100, exclusive`
      }) : null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        key: index,
        display: "rowCompressed",
        isInvalid: isInvalid,
        error: error
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        isInvalid: isInvalid,
        value: percentile,
        onChange: onPercentileChange,
        append: /*#__PURE__*/_react.default.createElement(_row_action_buttons.RowActionButtons, {
          onAdd: onAdd,
          onRemove: onRemove,
          showDeleteButton: this.state.percentiles.length > 1
        }),
        compressed: true
      }));
    });
    return /*#__PURE__*/_react.default.createElement("div", null, rows);
  }
}
exports.PercentilesForm = PercentilesForm;